/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ModelNatureExtension;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.jst.web.tld.IFilePathEncoder;

public class FilePathEncoderFactory {
    static IFilePathEncoder pathEncoderInstance;

    public static IFilePathEncoder getPathEncoder(String pathEncoder) {
        if (pathEncoderInstance != null) {
            return pathEncoderInstance;
        }
        if (pathEncoder == null) {
            return null;
        }
        if (pathEncoder.length() == 0) {
            pathEncoder = null;
            return null;
        }
        try {
            try {
                pathEncoderInstance = (IFilePathEncoder)ModelFeatureFactory.getInstance().createFeatureInstance(pathEncoder);
            }
            catch (ClassCastException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
                pathEncoder = null;
            }
        }
        finally {
            pathEncoder = null;
        }
        return pathEncoderInstance;
    }

    public static IFilePathEncoder getEncoder(IProject project) {
        if (project == null || !project.isOpen()) {
            return null;
        }
        ModelNatureExtension[] es = ModelNatureExtension.getInstances();
        int i = 0;
        while (i < es.length) {
            try {
                IFilePathEncoder encoder;
                if (project.hasNature(es[i].getName()) && (encoder = FilePathEncoderFactory.getPathEncoder(es[i].getPathEncoder())) != null) {
                    return encoder;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }
}

