/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.server;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerType;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.server.ServerManager;

public class RegistrationHelper {
    static String FORBIDDEN = ";/?:@&=+,$,\\";
    static String MODULE_NAME_PREFIX = "org.eclipse.jst.j2ee.server.web:";

    public static boolean isRegistered(String appname, IServer server) {
        IProject project = null;
        if (server != null) {
            IModule[] ms = server.getModules();
            int i = 0;
            while (i < ms.length && project == null) {
                IProject p;
                if (ms[i].getName().equals(appname) && (p = ms[i].getProject()) != null && p.exists() && p.isOpen()) {
                    project = p;
                }
                ++i;
            }
        }
        return RegistrationHelper.isRegistered(project, server);
    }

    public static boolean isRegistered(IProject project) {
        return RegistrationHelper.isRegistered(project, ServerManager.getInstance().getSelectedServer());
    }

    public static boolean isRegistered(IProject project, IServer server) {
        if (server == null || project == null) {
            return false;
        }
        IModule[] ms = server.getModules();
        IModule m = RegistrationHelper.findModule(project);
        return RegistrationHelper.contains(ms, m);
    }

    public static boolean canRegister(IProject project) {
        return RegistrationHelper.getSelectedServer() != null && !RegistrationHelper.isRegistered(project);
    }

    public static boolean canRegister(IProject project, IServer server) {
        return server != null && !RegistrationHelper.isRegistered(project, server);
    }

    public static String getRegistrationError(IProject project, String appname, IServer server) {
        if (server == null) {
            return WebUIMessages.SERVER_ISNOT_SELECTED;
        }
        String contextRootError = RegistrationHelper.checkContextRoot(appname);
        if (contextRootError != null) {
            return contextRootError;
        }
        IModule m = RegistrationHelper.findModule(project);
        return RegistrationHelper.getRegistrationError(m, appname, server);
    }

    public static String checkContextRoot(String appname) {
        if (appname == null) {
            return null;
        }
        int i = 0;
        while (i < appname.length()) {
            char c = appname.charAt(i);
            if (FORBIDDEN.indexOf(c) >= 0) {
                return NLS.bind((String)WebUIMessages.CONTEXT_ROOT_CANNOT_CONTAIN_CHARACTER, (Object)("" + c));
            }
            ++i;
        }
        return null;
    }

    public static String getRegistrationError(IModule m, String appname, IServer server) {
        if (server == null) {
            return WebUIMessages.SERVER_ISNOT_SELECTED;
        }
        if (m == null) {
            return WebUIMessages.CANNOT_FIND_MODULE_FOR_THE_PROJECT;
        }
        if (RegistrationHelper.contains(server.getModules(), m)) {
            return NLS.bind((String)WebUIMessages.APPLICATION_IS_ALREADY_REGISTERED, (Object)appname, (Object)server.getName());
        }
        IModule[] add = new IModule[]{m};
        IModule[] remove = new IModule[]{};
        try {
            server.getRootModules(m, null);
        }
        catch (CoreException ce) {
            WebModelPlugin.getPluginLog().logError((Throwable)ce);
            return ce.getStatus().getMessage();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IServerWorkingCopy copy = server.createWorkingCopy();
        IStatus status = copy.canModifyModules(add, remove, (IProgressMonitor)monitor);
        if (status != null && !status.isOK()) {
            return status.getMessage();
        }
        return null;
    }

    public static void register(IProject project) {
        RegistrationHelper.register(project, ServerManager.getInstance().getSelectedServer());
    }

    public static void register(IProject project, IServer server) {
        if (server == null) {
            return;
        }
        IModule m = RegistrationHelper.findModule(project);
        if (m == null) {
            return;
        }
        if (RegistrationHelper.contains(server.getModules(), m)) {
            return;
        }
        IModule[] add = new IModule[]{m};
        IModule[] remove = new IModule[]{};
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IServerWorkingCopy copy = server.createWorkingCopy();
            IStatus status = copy.canModifyModules(add, remove, (IProgressMonitor)monitor);
            if (status != null && !status.isOK()) {
                return;
            }
            ServerUtil.modifyModules((IServerWorkingCopy)copy, (IModule[])add, (IModule[])remove, (IProgressMonitor)monitor);
            copy.save(true, (IProgressMonitor)monitor);
            if (RegistrationHelper.canPublish(server)) {
                server.publish(1, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static boolean canPublish(IServer server) {
        if (server == null || server.getRuntime() == null) {
            return false;
        }
        return !((ServerType)server.getServerType()).startBeforePublish() || server.getServerState() == 2;
    }

    public static boolean canUnregister(IProject project) {
        return RegistrationHelper.getSelectedServer() != null && RegistrationHelper.isRegistered(project);
    }

    public static boolean unregister(IProject project) {
        return RegistrationHelper.unregister(project, RegistrationHelper.getSelectedServer());
    }

    public static boolean unregister(IProject project, IServer server) {
        if (server == null) {
            return false;
        }
        IModule m = RegistrationHelper.findModule(project);
        if (!RegistrationHelper.contains(server.getModules(), m)) {
            return false;
        }
        IModule[] add = new IModule[]{};
        IModule[] remove = new IModule[]{m};
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IServerWorkingCopy copy = server.createWorkingCopy();
            ServerUtil.modifyModules((IServerWorkingCopy)copy, (IModule[])add, (IModule[])remove, (IProgressMonitor)monitor);
            copy.save(true, (IProgressMonitor)monitor);
            if (RegistrationHelper.canPublish(server)) {
                server.publish(1, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return true;
    }

    public static IServer getSelectedServer() {
        return ServerManager.getInstance().getSelectedServer();
    }

    private static boolean contains(IModule[] modules, IModule module) {
        if (modules == null || module == null) {
            return false;
        }
        int i = 0;
        while (i < modules.length) {
            if (modules[i].getName() != null && modules[i].getName().equals(module.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IModule findModule(IProject project) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules != null && modules.length > 0) {
            int i = 0;
            while (i < modules.length) {
                if (!"jboss.singlefile".equals(modules[i].getModuleType().getId())) {
                    return modules[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static void runRegisterInServerJob(IProject p, IServer server) {
        RegistrationHelper.runRegisterInServerJob(p, new IServer[]{server}, null);
    }

    public static void runRegisterInServerJob(IProject p, IServer[] servers, String contextRoot) {
        RegisterServerJob job = new RegisterServerJob(p, servers, contextRoot);
        job.schedule(100L);
    }

    private static void register(IProject p, IServer[] servers, String contextRoot, IProgressMonitor monitor) throws XModelException {
        if (monitor != null) {
            monitor.beginTask("", 100);
        }
        if (monitor != null) {
            monitor.worked(5);
        }
        int step = 70;
        if (monitor != null) {
            monitor.worked(5);
            step /= 2 * servers.length + 1;
        }
        if (contextRoot != null && !contextRoot.equals(ComponentUtilities.getServerContextRoot((IProject)p))) {
            ComponentUtilities.setServerContextRoot((IProject)p, (String)contextRoot);
        }
        int i = 0;
        while (i < servers.length) {
            if (monitor != null) {
                monitor.worked(step);
                monitor.subTask(servers[i].getName());
            }
            RegistrationHelper.register(p, servers[i]);
            if (monitor != null) {
                monitor.worked(step);
            }
            ++i;
        }
        if (contextRoot != null) {
            XModelObject object;
            XModel model;
            IModelNature n = EclipseResourceUtil.getModelNature((IProject)p);
            XModel xModel = model = n == null ? null : n.getModel();
            if (model != null && (object = FileSystemsHelper.getFileSystems((XModel)model)) != null) {
                model.changeObjectAttribute(object, "application name", contextRoot);
            }
        }
        if (monitor != null) {
            monitor.worked(20);
        }
    }

    private static class RegisterServerJob
    extends Job {
        long counter = 100L;
        IProject p;
        IServer[] servers;
        String contextRoot;

        public RegisterServerJob(IProject p, IServer[] servers, String contextRoot) {
            super(WebUIMessages.RegistrationHelper_RegisterInServer);
            this.p = p;
            this.servers = servers;
            this.contextRoot = contextRoot;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (RegistrationHelper.findModule(this.p) == null) {
                    this.counter *= 2L;
                    if (this.counter > 10000L) {
                        String mesage = MessageFormat.format(WebUIMessages.RegistrationHelper_TimeoutExpired, this.p);
                        return new Status(4, "org.jboss.tools.jst.web", 0, mesage, null);
                    }
                    this.schedule(this.counter);
                } else {
                    ModelPlugin.getWorkspace().run((IWorkspaceRunnable)new WR(), monitor);
                }
            }
            catch (CoreException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }

        class WR
        implements IWorkspaceRunnable {
            WR() {
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    RegistrationHelper.register(RegisterServerJob.this.p, RegisterServerJob.this.servers, RegisterServerJob.this.contextRoot, monitor);
                }
                catch (XModelException e) {
                    WebModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
    }
}

