/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.version;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddLibraryToVersionSupport;
import org.jboss.tools.jst.web.project.helpers.LibrarySet;
import org.jboss.tools.jst.web.project.helpers.LibrarySets;
import org.jboss.tools.jst.web.project.version.ProjectVersions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectVersion {
    ProjectVersions versions;
    Element element;
    String name;
    LibraryReference[] libraries = new LibraryReference[0];
    String projectTemplatesLocation;
    String[] order = new String[0];
    String preferredServletVersion = null;

    ProjectVersion(ProjectVersions versions) {
        this.versions = versions;
    }

    public String getName() {
        return this.name;
    }

    public String[] getLibraryNames() {
        String[] r = new String[this.libraries.length];
        int i = 0;
        while (i < this.libraries.length) {
            r[i] = this.libraries[i].name;
            ++i;
        }
        return r;
    }

    public String[] getLibraryLocations() {
        String[] r = new String[this.libraries.length];
        int i = 0;
        while (i < this.libraries.length) {
            r[i] = this.libraries[i].location;
            ++i;
        }
        return r;
    }

    public String getProjectTemplatesLocation() {
        return this.projectTemplatesLocation;
    }

    public String getPreferredServletVersion() {
        return this.preferredServletVersion;
    }

    public String getErrorMessage() {
        LibraryReference core = null;
        LibraryReference common = null;
        int i = 0;
        while (i < this.libraries.length) {
            if ("core".equals(this.libraries[i].type)) {
                core = this.libraries[i];
            }
            if ("common".equals(this.libraries[i].type)) {
                common = this.libraries[i];
            }
            ++i;
        }
        if (core == null || core.location.length() == 0) {
            return NLS.bind((String)WebUIMessages.CORE_LIBRARY_LOCATION_ISNOT_SET_FOR_VERSION, (Object)this.name);
        }
        if (!new File(core.location).isDirectory()) {
            return NLS.bind((String)WebUIMessages.CORE_LIBRARY_LOCATION_FOR_VERSION_ISNOT_CORRECT, (Object)this.name);
        }
        if (common != null && !new File(common.location).isDirectory()) {
            return NLS.bind((String)WebUIMessages.COMMON_LIBRARY_LOCATION_FOR_VERSION_ISNOT_CORRECT, (Object)this.name);
        }
        if (this.projectTemplatesLocation == null || this.projectTemplatesLocation.length() == 0) {
            return NLS.bind((String)WebUIMessages.TEMPLATES_LOCATION_ISNOT_SET_FOR_VERSION, (Object)this.name);
        }
        if (!new File(this.projectTemplatesLocation).isDirectory()) {
            return NLS.bind((String)WebUIMessages.TEMPLATES_LOCATION_FOR_VERSION_ISNOT_CORRECT, (Object)this.name);
        }
        return null;
    }

    void load(Element e) {
        this.element = e;
        this.name = e.getAttribute("displayName");
        String sv = e.getAttribute("servlet-version");
        if (sv != null && sv.trim().length() > 0) {
            this.preferredServletVersion = sv.trim();
        }
        ArrayList<LibraryReference> ls = new ArrayList<LibraryReference>();
        NodeList nl = e.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element ne;
            String location;
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && (location = (ne = (Element)n).getAttribute("location")) != null && location.length() != 0) {
                location = this.versions.getAbsoluteLocation(location);
                if ("lib".equals(ne.getNodeName())) {
                    int c = location.lastIndexOf(47);
                    String name = location.substring(c + 1);
                    LibraryReference l = this.getLibrary(name);
                    if (l == null) {
                        l = new LibraryReference();
                        l.name = name;
                    }
                    l.type = ne.getAttribute("type");
                    l.location = location;
                    l.e = ne;
                    ls.add(l);
                } else if ("projectTempl".equals(ne.getNodeName())) {
                    this.projectTemplatesLocation = location;
                    Element[] es = XMLUtilities.getChildren((Element)ne, (String)"project");
                    this.order = new String[es.length];
                    int j = 0;
                    while (j < this.order.length) {
                        this.order[j] = es[j].getAttribute("name");
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.libraries = ls.toArray(new LibraryReference[0]);
    }

    public String addLibrary() {
        return AddLibraryToVersionSupport.run(this);
    }

    public void addLibrary(String name) {
        if (this.element == null) {
            return;
        }
        this.addLibrary(name, "user");
        this.versions.save();
        this.load(this.element);
    }

    void addLibrary(String name, String type) {
        LibrarySet set = LibrarySets.getInstance().getLibrarySet(name);
        if (set == null) {
            return;
        }
        String location = String.valueOf(LibrarySets.getInstance().getLibrarySetsPath()) + "/" + name;
        Element lib = XMLUtil.createElement((Element)this.element, (String)"lib");
        lib.setAttribute("location", ProjectVersion.getRelativePath(this.versions.path, location));
        lib.setAttribute("type", type);
    }

    static String getRelativePath(String root, String location) {
        String loc = FileUtil.getRelativePath((String)root, (String)location);
        if (loc == null) {
            return location;
        }
        if (loc.startsWith("/..")) {
            return loc.substring(1);
        }
        if (loc.startsWith("/")) {
            return "." + loc;
        }
        return loc;
    }

    public void removeLibrary(String name) {
        LibraryReference l = this.getLibrary(name);
        if (l == null || l.e == null) {
            return;
        }
        if (!ProjectVersion.confirm(NLS.bind((String)WebUIMessages.YOU_WANT_TO_DELETE_LIBRARY, (Object)name))) {
            return;
        }
        l.e.getParentNode().removeChild(l.e);
        this.versions.save();
        this.load(this.element);
    }

    LibraryReference getLibrary(String name) {
        int i = 0;
        while (i < this.libraries.length) {
            if (this.libraries[i].name.equals(name)) {
                return this.libraries[i];
            }
            ++i;
        }
        return null;
    }

    static boolean confirm(String message) {
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        return d.showDialog(WebUIMessages.CONFIRMATION, message, new String[]{WebUIMessages.OK, WebUIMessages.CANCEL}, null, 0) == 0;
    }

    public void setOrder(String[] order) {
        this.order = order;
        if (this.element == null) {
            return;
        }
        Element e = XMLUtilities.getUniqueChild((Element)this.element, (String)"projectTempl");
        if (e == null) {
            return;
        }
        Element[] es = XMLUtilities.getChildren((Element)e, (String)"project");
        int i = 0;
        while (i < es.length) {
            e.removeChild(es[i]);
            ++i;
        }
        i = 0;
        while (i < order.length) {
            Element c = XMLUtilities.createElement((Element)e, (String)"project");
            c.setAttribute("name", order[i]);
            ++i;
        }
        this.versions.save();
    }

    public String[] getOrder() {
        return this.order;
    }

    class LibraryReference {
        String name;
        String location;
        String type;
        Element e;

        LibraryReference() {
        }
    }
}

