/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.impl.PropertiesLoader;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.project.version.ProjectVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTemplate {
    public static String PREPROCESSING_PROPERTIES = ".preprocessing.properties";
    public static String PREPROCESSING = ".preprocessing";
    ProjectVersion projectVersion;
    File root;
    File location;
    String name;
    File preprocessingFile;
    File propertiesFile;
    ArrayList<String> preprocessingFiles;
    XModelObject properties;

    public void setProjectVersion(ProjectVersion version) {
        this.projectVersion = version;
    }

    public ProjectVersion getProjectVersion() {
        return this.projectVersion;
    }

    public void init(String name, String root) {
        this.root = new File(root);
        this.location = new File(root, name);
        this.name = name;
        this.preprocessingFile = new File(this.location, PREPROCESSING);
        this.propertiesFile = new File(this.location, PREPROCESSING_PROPERTIES);
        this.loadPreprocessing();
        this.loadProperties();
    }

    public File getLocation() {
        return this.location;
    }

    void loadPreprocessing() {
        String body = FileUtil.readFile((File)this.preprocessingFile);
        StringTokenizer st = new StringTokenizer(body, "\r\n");
        this.preprocessingFiles = new ArrayList();
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.length() <= 0) continue;
            this.preprocessingFiles.add(t);
        }
    }

    void loadProperties() {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        this.properties = model.createModelObject("FilePROPERTIES", null);
        this.properties.setAttributeValue("name", ".preprocessing");
        this.properties.setAttributeValue("extension", "properties");
        PropertiesLoader loader = new PropertiesLoader();
        XModelObjectLoaderUtil.setTempBody((XModelObject)this.properties, (String)FileUtil.readFile((File)this.propertiesFile));
        loader.load(this.properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<String> getPreprocessingFiles() {
        return this.preprocessingFiles;
    }

    public XModelObject getProperties() {
        return this.properties;
    }

    public boolean isNameModified() {
        return !this.name.equals(this.location.getName());
    }

    public void commit() {
        this.commitPreprocessingFile();
        this.commitPropertiesFile();
        this.commitName();
    }

    void commitPreprocessingFile() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.preprocessingFiles.size()) {
            sb.append(this.preprocessingFiles.get(i)).append("\n");
            ++i;
        }
        String body = sb.toString();
        String oldBody = FileUtil.readFile((File)this.preprocessingFile);
        if (oldBody.equals(body)) {
            return;
        }
        FileUtil.writeFile((File)this.preprocessingFile, (String)body);
    }

    void commitPropertiesFile() {
        PropertiesLoader loader = new PropertiesLoader();
        String body = loader.getBody(this.properties);
        String oldBody = FileUtil.readFile((File)this.propertiesFile);
        if (oldBody.equals(body)) {
            return;
        }
        FileUtil.writeFile((File)this.propertiesFile, (String)body);
    }

    void commitName() {
        if (!this.isNameModified()) {
            return;
        }
        String oldName = this.location.getName();
        File newLocation = new File(this.root, this.name);
        boolean b = this.location.renameTo(newLocation);
        if (!b) {
            FileUtil.copyDir((File)this.location, (File)newLocation, (boolean)true);
            FileUtil.remove((File)this.location);
        }
        this.updateOrder(oldName);
        this.location = newLocation;
        this.preprocessingFile = new File(this.location, ".preprocessing");
        this.propertiesFile = new File(this.location, ".preprocessing.properties");
    }

    private void updateOrder(String oldName) {
        if (this.projectVersion == null) {
            return;
        }
        String[] order = this.projectVersion.getOrder();
        int i = 0;
        while (i < order.length) {
            if (order[i].equals(oldName)) {
                order[i] = this.name;
                this.projectVersion.setOrder(order);
                return;
            }
            ++i;
        }
    }
}

