/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.MultistepWizardStep;
import org.jboss.tools.common.meta.action.impl.MultistepWizardSupport;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateNameStep;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplatePropertiesStep;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateResourcesStep;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateVelocityStep;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;

public class AddProjectTemplateSupport
extends MultistepWizardSupport {
    static int NAME_STEP = 0;
    static int RESOURCES_STEP = 1;
    static int VELOCITY_STEP = 2;
    static int PROPERTIES_STEP = 3;
    AddProjectTemplateResourcesStep resourcesStep;
    AddProjectTemplateVelocityStep velocityStep;
    AddProjectTemplatePropertiesStep propertiesStep;
    AbstractWebProjectTemplate template;
    Set<String> templates;
    String version;
    IProject presetProject;
    Map<String, XModel> models;
    protected DefaultWizardDataValidator validator = new ProjectTemplateValidator();

    public static String run(AbstractWebProjectTemplate template, String entity, String version) {
        String actionPath = "CreateActions.CreateProjectTemplate";
        Properties p = new Properties();
        p.put("version", version);
        return AddProjectTemplateSupport.run(template, entity, actionPath, p);
    }

    public static String run(AbstractWebProjectTemplate template, String entity, IProject project) {
        String actionPath = "CreateActions.CreateProjectTemplate2";
        Properties p = new Properties();
        p.put("project", project);
        return AddProjectTemplateSupport.run(template, entity, actionPath, p);
    }

    static String run(AbstractWebProjectTemplate template, String entity, String actionPath, Properties p) {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        p.put("template", template);
        XActionInvoker.invoke((String)entity, (String)actionPath, (XModelObject)model.getRoot(), (Properties)p);
        return p.getProperty("name");
    }

    protected MultistepWizardStep[] createSteps() {
        MultistepWizardStep[] multistepWizardStepArray = new MultistepWizardStep[4];
        multistepWizardStepArray[0] = new AddProjectTemplateNameStep();
        this.resourcesStep = new AddProjectTemplateResourcesStep();
        multistepWizardStepArray[1] = this.resourcesStep;
        this.velocityStep = new AddProjectTemplateVelocityStep();
        multistepWizardStepArray[2] = this.velocityStep;
        this.propertiesStep = new AddProjectTemplatePropertiesStep();
        multistepWizardStepArray[3] = this.propertiesStep;
        return multistepWizardStepArray;
    }

    public void reset() {
        this.initSteps();
        this.template = (AbstractWebProjectTemplate)this.getProperties().get("template");
        this.setVersion(this.getProperties().getProperty("version"));
        this.presetProject = (IProject)this.getProperties().get("project");
        if (this.presetProject == null) {
            this.setProjectList();
        } else {
            this.setAttributeValue(NAME_STEP, "name", this.presetProject.getName());
            this.setVersionList();
            try {
                this.prepareStep(RESOURCES_STEP);
            }
            catch (XModelException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public String getSubtitle() {
        int id = this.getStepId();
        return id == NAME_STEP ? WebUIMessages.DEFINE_COMMON_TEMPLATE_PROPERTIES : (id == RESOURCES_STEP ? WebUIMessages.SELECT_FOLDERS_AND_FILES : (id == VELOCITY_STEP ? WebUIMessages.SELECT_FILES_THAT_ARE_VELOCITY_TEMPLATES : (id == PROPERTIES_STEP ? WebUIMessages.SET_VELOCITY_PROPERTIES : "")));
    }

    void setVersion(String v) {
        this.version = v;
        this.templates = new HashSet<String>();
        if (v != null) {
            String[] ts = this.template.getTemplateList(this.version);
            int i = 0;
            while (i < ts.length) {
                this.templates.add(ts[i]);
                ++i;
            }
        }
    }

    void setVersionList() {
        String[] s = this.template.getVersionList();
        this.setValueList(NAME_STEP, "implementation", s);
        if (s.length != 0) {
            this.setAttributeValue(NAME_STEP, "implementation", s[0]);
            this.setVersion(s[0]);
        }
    }

    public IProject getSelectedProject() {
        if (this.presetProject != null) {
            return this.presetProject;
        }
        String project = this.getAttributeValue(0, "project");
        if (project == null || project.length() == 0) {
            return null;
        }
        return ModelPlugin.getWorkspace().getRoot().getProject(project);
    }

    void setProjectList() {
        String nature = this.getEntityData()[0].getModelEntity().getAttribute("nature").getDefaultValue();
        IProject[] ps = ModelPlugin.getWorkspace().getRoot().getProjects();
        this.models = new TreeMap<String, XModel>();
        int i = 0;
        while (i < ps.length) {
            IModelNature n;
            if (ps[i].isOpen() && (n = EclipseResourceUtil.getModelNature((IProject)ps[i], (String)nature)) != null) {
                this.models.put(ps[i].getName(), n.getModel());
            }
            ++i;
        }
        String[] pl = this.models.keySet().toArray(new String[0]);
        this.setValueList(0, "project", pl);
        if (pl.length != 0) {
            this.setAttributeValue(0, "project", pl[0]);
            this.setAttributeValue(0, "name", pl[0]);
        }
    }

    protected void prepareStep(int nextStep) throws XModelException {
        if (nextStep == RESOURCES_STEP) {
            this.getProperties().put("ResourcesStep", this.steps[RESOURCES_STEP]);
            this.resourcesStep.init();
            this.velocityStep.init();
        } else if (nextStep == VELOCITY_STEP) {
            this.velocityStep.init();
        }
    }

    protected void execute() throws XModelException {
        Properties p0 = this.extractStepData(0);
        String name = p0.getProperty("name");
        IProject project = this.getSelectedProject();
        XModel model = EclipseResourceUtil.getModelNature((IProject)project).getModel();
        String location = this.template.getProjectTemplatesLocation(this.version);
        File target = new File(location, name);
        File source = project.getLocation().toFile();
        this.resourcesStep.copyProjectToTemplate(target, source, model);
        this.velocityStep.createPreprocessingFile(target);
        this.propertiesStep.createPropertiesFile(target);
        this.getProperties().setProperty("name", name);
    }

    public WizardDataValidator getValidator(int step) {
        if (step == 0) {
            this.validator.setSupport((SpecialWizardSupport)this, step);
            return this.validator;
        }
        return super.getValidator(step);
    }

    class ProjectTemplateValidator
    extends DefaultWizardDataValidator {
        ProjectTemplateValidator() {
        }

        public void validate(Properties data) {
            String name;
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            if (AddProjectTemplateSupport.this.presetProject != null) {
                AddProjectTemplateSupport.this.setVersion(AddProjectTemplateSupport.this.getAttributeValue(NAME_STEP, "implementation"));
            }
            if (AddProjectTemplateSupport.this.templates.contains(name = data.getProperty("name"))) {
                this.message = NLS.bind((String)WebUIMessages.PROJECT_TEMPLATE_ALREADY_EXISTS, (Object)name);
                return;
            }
            String p = data.getProperty("project");
            if (AddProjectTemplateSupport.this.presetProject == null && !AddProjectTemplateSupport.this.models.containsKey(p)) {
                this.message = NLS.bind((String)WebUIMessages.CANNOT_CREATE_TEMPLATE_FOR_PROJECT, (Object)p);
            }
        }
    }
}

