/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;

public class AddPageTemplateSupport
extends SpecialWizardSupport {
    AbstractWebProjectTemplate template;
    Map pageTemplates;
    protected DefaultWizardDataValidator validator = new PageTemplateValidator();
    IFile selectedFile;
    String pagePath;

    public static String run(AbstractWebProjectTemplate template, String entity, XModelObject selection) {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        String actionPath = "CreateActions.CreatePageTemplate";
        Properties p = new Properties();
        p.put("template", template);
        if (selection != null) {
            p.put("selection", selection);
        }
        XActionInvoker.invoke((String)entity, (String)actionPath, (XModelObject)model.getRoot(), (Properties)p);
        return p.getProperty("name");
    }

    public void reset() {
        this.template = (AbstractWebProjectTemplate)this.getProperties().get("template");
        this.pageTemplates = this.template.getPageTemplates();
        this.initSelection();
    }

    private void initSelection() {
        XModelObject selection = (XModelObject)this.getProperties().get("selection");
        if (selection == null) {
            return;
        }
        IFile f = (IFile)EclipseResourceUtil.getResource((XModelObject)selection);
        if (f == null) {
            return;
        }
        String path = f.getFullPath().toString();
        this.setAttributeValue(0, "page path", path);
        this.setAttributeValue(0, "name", selection.getAttributeValue("name"));
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    protected void execute() throws XModelException {
        Properties p0 = this.extractStepData(0);
        String name = p0.getProperty("name");
        String path = p0.getProperty("page path");
        IFile r = this.getSelectedResource(path);
        if (r != null) {
            this.template.addPageTemplate(this.getFinalTemplateName(r, name), r);
        }
        this.getProperties().setProperty("name", name);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    String getFinalTemplateName(IFile f, String name) {
        String n = f.getName();
        if (n.indexOf(".jsp") >= 0) {
            return name;
        }
        int q = n.lastIndexOf(46);
        if (q < 0) {
            return name;
        }
        String ext = n.substring(q);
        if (name.endsWith(ext)) {
            return name;
        }
        return String.valueOf(name) + ext;
    }

    IFile getSelectedResource(String pagePath) {
        if (pagePath == null) {
            return null;
        }
        if (pagePath.equals(this.pagePath)) {
            return this.selectedFile;
        }
        this.pagePath = pagePath;
        IResource r = ModelPlugin.getWorkspace().getRoot().findMember((IPath)new Path(pagePath));
        this.selectedFile = r instanceof IFile ? (IFile)r : null;
        return this.selectedFile;
    }

    class PageTemplateValidator
    extends DefaultWizardDataValidator {
        PageTemplateValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (AddPageTemplateSupport.this.pageTemplates.containsKey(name)) {
                this.message = NLS.bind((String)WebUIMessages.TEMPLATE_PAGE_ALREADY_EXISTS, (Object)name);
                return;
            }
            IFile r = AddPageTemplateSupport.this.getSelectedResource(data.getProperty("page path"));
            if (r == null || !r.exists()) {
                this.message = WebUIMessages.PAGE_PATH_ISNOT_CORRECT;
                return;
            }
            String n = AddPageTemplateSupport.this.getFinalTemplateName(r, name);
            if (!name.equals(n) && AddPageTemplateSupport.this.pageTemplates.containsKey(n)) {
                this.message = NLS.bind((String)WebUIMessages.TEMPLATE_PAGE_ALREADY_EXISTS, (Object)n);
                return;
            }
        }
    }
}

