/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.helpers.LibrarySets;
import org.jboss.tools.jst.web.project.version.ProjectVersion;

public class AddLibraryToVersionSupport
extends SpecialWizardSupport {
    ProjectVersion version;
    Set<String> names;
    Set<String> usedNames;
    protected DefaultWizardDataValidator validator = new LibraryValidator();

    public static String run(ProjectVersion version) {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        String entity = "LibraryReference";
        String actionPath = "CreateActions.CreateLibraryReference";
        Properties p = new Properties();
        p.put("version", version);
        XActionInvoker.invoke((String)entity, (String)actionPath, (XModelObject)model.getRoot(), (Properties)p);
        return p.getProperty("name");
    }

    public void reset() {
        this.version = (ProjectVersion)this.getProperties().get("version");
        if (this.version == null) {
            this.setFinished(true);
            return;
        }
        this.setLibraryList();
    }

    void setLibraryList() {
        this.names = new TreeSet<String>();
        this.usedNames = new HashSet<String>();
        String[] all = LibrarySets.getInstance().getLibrarySetList();
        int i = 0;
        while (i < all.length) {
            this.names.add(all[i]);
            ++i;
        }
        String[] exclude = this.version.getLibraryNames();
        int i2 = 0;
        while (i2 < exclude.length) {
            this.names.remove(exclude[i2]);
            this.usedNames.add(exclude[i2]);
            ++i2;
        }
        String[] pl = this.names.toArray(new String[0]);
        this.setValueList(0, "name", pl);
        if (pl.length > 0) {
            this.setAttributeValue(0, "name", pl[0]);
        }
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    protected void execute() throws XModelException {
        String name = this.extractStepData(0).getProperty("name");
        this.version.addLibrary(name);
        this.getProperties().setProperty("name", name);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    class LibraryValidator
    extends DefaultWizardDataValidator {
        LibraryValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (AddLibraryToVersionSupport.this.usedNames.contains(name)) {
                this.message = NLS.bind((String)WebUIMessages.LIBRARY_SET_IS_ALREADY_ADDED, (Object)name);
            } else if (!AddLibraryToVersionSupport.this.names.contains(name)) {
                this.message = NLS.bind((String)WebUIMessages.LIBRARY_SET_ISNOT_FOUND, (Object)name);
            }
        }
    }
}

