/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ClassPathUpdate;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.WebPreference;
import org.jboss.tools.jst.web.WebUtils;

public class AddServletSupportWizard
implements SpecialWizard {
    XModel model;
    ClassPathUpdate update;

    public void setObject(Object object) {
        this.update = (ClassPathUpdate)object;
        this.model = this.update.getModel();
    }

    public int execute() {
        try {
            this.addServletSupport();
        }
        catch (XModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            return 1;
        }
        return 0;
    }

    private void addServletSupport() throws XModelException {
        XModelObject web = this.model.getByPath("Web");
        if (web == null) {
            return;
        }
        String servletVersion = web.getAttributeValue("servlet version");
        if (servletVersion == null || "".equals(servletVersion)) {
            servletVersion = WebPreference.DEFAULT_SERVLET_VERSION.getValue();
            this.model.changeObjectAttribute(web, "servlet version", servletVersion);
        }
        String[] jars = WebUtils.getServletLibraries(this.getTemplatesBase(), servletVersion);
        if (web.getChildren("JstWebModule").length == 0 && web.getChildren("WebJSFModule").length == 0) {
            return;
        }
        int i = 0;
        while (i < jars.length) {
            Path jarPath = new Path(jars[i]);
            IPath variablePath = JavaCore.getClasspathVariable((String)jarPath.segment(0));
            IClasspathEntry entry = null;
            entry = variablePath == null ? this.update.createNewClasspathEntry((IPath)jarPath, 1) : this.update.createNewClasspathEntry((IPath)jarPath, 4);
            this.update.registerEntry(entry);
            ++i;
        }
    }

    public String getTemplatesBase() {
        return String.valueOf(WebModelPlugin.getTemplateStateLocation()) + "templates";
    }
}

