/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.project.ext.store;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.common.model.project.ext.store.XMLStoreConstants;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStoreHelper
implements XMLStoreConstants {
    public static void saveValueInfo(Element parent, IValueInfo value, Properties context) {
        value.toXML(parent, context);
    }

    public static IValueInfo loadValueInfo(Element parent, Properties context) {
        Element c = XMLUtilities.getUniqueChild((Element)parent, (String)"value-info");
        if (c == null) {
            return null;
        }
        XMLValueInfo v = null;
        if ("xml".equals(c.getAttribute("class"))) {
            v = new XMLValueInfo();
            v.loadXML(c, context);
            if (v.getObject() == null) {
                v = new ValueInfo();
                ((ValueInfo)v).setValue("");
            }
        } else {
            v = new ValueInfo();
            v.loadXML(c, context);
        }
        return v;
    }

    public static void saveModelObject(Element element, XModelObject object, Properties context) {
        IProject p;
        if (object == null) {
            return;
        }
        String path = object.getPath();
        if (path == null) {
            return;
        }
        XModelObject base = (XModelObject)context.get("model-object");
        if (base != null && base.getModel() == object.getModel()) {
            String basePath = base.getPath();
            if (path.startsWith(basePath + "/")) {
                path = path.substring(basePath.length());
            } else if (path.equals(basePath)) {
                path = ".";
            }
        }
        if (path != null) {
            element.setAttribute("path", path);
        }
        if ((p = EclipseResourceUtil.getProject((XModelObject)object)) == null) {
            return;
        }
        element.setAttribute("project", p.getName());
    }

    public static void saveModelObject(Element parent, XModelObject object, String child, Properties context) {
        Element element = XMLUtilities.createElement((Element)parent, (String)child);
        element.setAttribute("class", "model-object");
        XMLStoreHelper.saveModelObject(element, object, context);
    }

    public static XModelObject loadModelObject(Element element, Properties context) {
        String path = element.getAttribute("path");
        XModelObject base = (XModelObject)context.get("model-object");
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.equals(".")) {
            return base;
        }
        if (path.startsWith("/")) {
            if (base != null) {
                base.getChildByPath(path.substring(1));
                return base.getChildByPath(path.substring(1));
            }
            return null;
        }
        IProject project = XMLStoreHelper.loadProject(element, context);
        if (project == null || !project.isAccessible()) {
            return null;
        }
        XModel model = InnerModelHelper.createXModel(project);
        if (model == null) {
            return null;
        }
        return model.getByPath(path);
    }

    public static XModelObject loadModelObject(Element parent, String child, Properties context) {
        Element element = XMLUtilities.getUniqueChild((Element)parent, (String)child);
        if (element == null) {
            return null;
        }
        return XMLStoreHelper.loadModelObject(element, context);
    }

    public static void saveType(Element element, IType type, Properties context) {
        if (type == null) {
            return;
        }
        if (context != null && type == context.get("type")) {
            return;
        }
        element.setAttribute("project", type.getJavaProject().getProject().getName());
        element.setAttribute("type", type.getFullyQualifiedName());
    }

    public static void saveType(Element parent, IType type, String child, Properties context) {
        if (type == null) {
            return;
        }
        if (context != null && type == context.get("type")) {
            return;
        }
        Element element = XMLUtilities.createElement((Element)parent, (String)child);
        element.setAttribute("class", "type");
        XMLStoreHelper.saveType(element, type, context);
    }

    public static IProject loadProject(Element element, Properties context) {
        String project = element.getAttribute("project");
        if (project == null || project.length() == 0) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(project);
    }

    public static IType loadType(Element element, Properties context) {
        String name = element.getAttribute("type");
        if (name == null || name.length() == 0) {
            if (context != null && context.containsKey("type")) {
                return (IType)context.get("type");
            }
            return null;
        }
        IProject project = XMLStoreHelper.loadProject(element, context);
        if (project == null || !project.isAccessible()) {
            return null;
        }
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp != null) {
            try {
                IType type = jp.findType(name.replace('$', '.'));
                if (type == null && name.indexOf(36) >= 0) {
                    int ii = name.lastIndexOf(46);
                    String pack = ii < 0 ? "" : name.substring(0, ii);
                    String cls = name.substring(ii + 1);
                    type = jp.findType(pack, cls.replace('$', '.'), (IProgressMonitor)new NullProgressMonitor());
                }
                return type;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static void saveField(Element element, IField field, Properties context) {
        if (field == null) {
            return;
        }
        XMLStoreHelper.saveType(element, field.getDeclaringType(), context);
        element.setAttribute("name", field.getElementName());
    }

    public static void saveField(Element parent, IField field, String child, Properties context) {
        if (field == null) {
            return;
        }
        Element element = XMLUtilities.createElement((Element)parent, (String)child);
        element.setAttribute("class", "field");
        XMLStoreHelper.saveField(element, field, context);
    }

    public static IField loadField(Element element, Properties context) {
        IType type = XMLStoreHelper.loadType(element, context);
        if (type == null) {
            return null;
        }
        String name = element.getAttribute("name");
        if (name == null || name.length() == 0) {
            return null;
        }
        return type.getField(name);
    }

    public static void saveMethod(Element element, IMethod method, Properties context) {
        if (method == null) {
            return;
        }
        XMLStoreHelper.saveType(element, method.getDeclaringType(), context);
        element.setAttribute("name", method.getElementName());
        String[] s = method.getParameterTypes();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length) {
            sb.append(s[i]).append(',');
            ++i;
        }
        element.setAttribute("params", sb.toString());
    }

    public static void saveMethod(Element parent, IMethod method, String child, Properties context) {
        if (method == null) {
            return;
        }
        Element element = XMLUtilities.createElement((Element)parent, (String)child);
        element.setAttribute("class", "method");
        XMLStoreHelper.saveMethod(element, method, context);
    }

    public static IMethod loadMethod(Element element, Properties context) {
        IType type = XMLStoreHelper.loadType(element, context);
        if (type == null) {
            return null;
        }
        String name = element.getAttribute("name");
        if (name == null || name.length() == 0) {
            return null;
        }
        String params = element.getAttribute("params");
        String[] ps = new String[]{};
        if (params != null && params.length() > 0) {
            ps = params.split(",");
        }
        return type.getMethod(name, ps);
    }

    public static void saveMap(Element parent, Map<String, IValueInfo> map, String child, Properties context) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Element element = XMLUtilities.createElement((Element)parent, (String)child);
        for (String name : map.keySet()) {
            IValueInfo value = map.get(name);
            Element c = XMLUtilities.createElement((Element)element, (String)"entry");
            c.setAttribute("name", name);
            if (value == null) continue;
            value.toXML(c, context);
        }
    }

    public static void loadMap(Element parent, Map<String, IValueInfo> map, String child, Properties context) {
        Element element = XMLUtilities.getUniqueChild((Element)parent, (String)child);
        if (element == null) {
            return;
        }
        Element[] cs = XMLUtilities.getChildren((Element)element, (String)"entry");
        int i = 0;
        while (i < cs.length) {
            String name = cs[i].getAttribute("name");
            IValueInfo value = XMLStoreHelper.loadValueInfo(cs[i], context);
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++i;
        }
    }
}

