/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers.autolayout;

import org.jboss.tools.jst.web.model.helpers.autolayout.Group;
import org.jboss.tools.jst.web.model.helpers.autolayout.Item;

public class GroupArranger {
    Group group;
    int mgi = 0;
    boolean inited = false;

    public GroupArranger(Group group) {
        this.group = group;
    }

    private void init() {
        this.inited = true;
        int i = 0;
        while (i < this.group.items().length) {
            Item item = this.group.getItem(i);
            if (item.isOwned) {
                item.gravity = -1;
            } else if (item.inputs.length == 0) {
                item.gravity = 0;
            } else if (item.outputs.length == 0) {
                item.gravity = 2000;
            } else {
                item.gravity = 1000;
                ++this.mgi;
            }
            ++i;
        }
    }

    public void arrange() {
        this.init();
        while (this.mgi > 0) {
            this.split();
            if (this.mgi <= 0) continue;
            this.cut(this.findBestCutIndex());
        }
        this.reduce();
    }

    private void split() {
        int length = this.group.items().length;
        boolean work = true;
        while (work) {
            work = false;
            int i = 0;
            while (i < length) {
                Item item = this.group.getItem(i);
                if (item.gravity == 1000) {
                    int q = this.computeLowerWeight(i);
                    if (q < item.gravity) {
                        item.gravity = q;
                        work = true;
                        --this.mgi;
                    }
                    if (item.gravity == 1000 && (q = this.computeUpperWeight(i)) > item.gravity) {
                        item.gravity = q;
                        work = true;
                        --this.mgi;
                    }
                }
                ++i;
            }
        }
    }

    private int computeLowerWeight(int i0) {
        Item item = this.group.getItem(i0);
        int[] is = item.inputs;
        int q = 0;
        int i = 0;
        while (i < is.length) {
            if (item.inputActivities[i]) {
                Item si = this.group.allitems[is[i]];
                if (si.gravity + 1 > q) {
                    q = si.gravity + 1;
                }
            }
            ++i;
        }
        return q;
    }

    private int computeUpperWeight(int i0) {
        Item item = this.group.getItem(i0);
        int[] is = item.outputs;
        if (is.length == 0) {
            return item.gravity;
        }
        int q = 2000;
        int i = 0;
        while (i < is.length) {
            if (item.outputActivities[i]) {
                Item si = this.group.allitems[is[i]];
                if (si.gravity - 1 < q) {
                    q = si.gravity - 1;
                }
            }
            ++i;
        }
        return q == 2000 ? item.gravity : q;
    }

    void activateInput(Item item, int input, boolean b) {
        item.inputActivities[input] = b;
        Item i2 = this.group.allitems[item.inputs[input]];
        int[] is = i2.outputs;
        int i = 0;
        while (i < is.length) {
            if (is[i] == item.n) {
                i2.outputActivities[i] = b;
            }
            ++i;
        }
    }

    private int findBestCutIndex() {
        int k = -1;
        int w = 20000;
        int i = 0;
        while (i < this.group.items().length) {
            int w2;
            Item item = this.group.getItem(i);
            if (item.gravity == 1000 && (w2 = this.getCuttingPreference(i)) < w) {
                w = w2;
                k = i;
            }
            ++i;
        }
        return k;
    }

    private int getCuttingPreference(int i0) {
        Item si;
        Item item = this.group.getItem(i0);
        int[] is = item.inputs;
        int q = 0;
        int i = 0;
        while (i < is.length) {
            if (item.inputActivities[i]) {
                si = this.group.allitems[is[i]];
                if (si.gravity == 1000) {
                    ++q;
                }
            }
            ++i;
        }
        q *= 10;
        is = item.outputs;
        i = 0;
        while (i < is.length) {
            if (item.outputActivities[i]) {
                si = this.group.allitems[is[i]];
                if (si.gravity == 1000) {
                    --q;
                }
            }
            ++i;
        }
        return q;
    }

    private void cut(int i0) {
        Item item = this.group.getItem(i0);
        int[] is = item.inputs;
        int i = 0;
        while (i < is.length) {
            if (item.inputActivities[i]) {
                Item si = this.group.allitems[is[i]];
                if (si.gravity == 1000) {
                    this.activateInput(item, i, false);
                }
            }
            ++i;
        }
    }

    private void reduce() {
        int q;
        Item item;
        int i;
        boolean work = true;
        while (work) {
            work = false;
            i = 0;
            while (i < this.group.items().length) {
                item = this.group.getItem(i);
                if (item.gravity >= 0 && (q = this.computeLowerWeight(i)) < item.gravity) {
                    item.gravity = q;
                    work = true;
                }
                ++i;
            }
        }
        work = true;
        while (work) {
            work = false;
            i = 0;
            while (i < this.group.items().length) {
                item = this.group.getItem(i);
                if (item.gravity >= 0 && (q = this.computeUpperWeight(i)) > item.gravity) {
                    item.gravity = q;
                    work = true;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.group.items().length) {
            item = this.group.getItem(i);
            item.ix = item.gravity;
            ++i;
        }
        i = 0;
        while (i < this.group.items().length) {
            item = this.group.getItem(i);
            int[] cs = item.comments;
            int j = 0;
            while (j < cs.length) {
                this.group.allitems[cs[j]].ix = item.ix;
                ++j;
            }
            ++i;
        }
    }
}

