/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers.autolayout;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.autolayout.Item;
import org.jboss.tools.jst.web.model.helpers.autolayout.Items;
import org.jboss.tools.jst.web.model.helpers.autolayout.LayuotConstants;
import org.jboss.tools.jst.web.model.helpers.autolayout.TransitionArranger;

public class AutoLayout {
    LayuotConstants constants;
    protected Items items;

    public void setItems(Items items) {
        this.items = items;
        this.constants = items.constants;
        this.constants.update();
    }

    public void setOverride(boolean b) {
        this.items.setOverride(b);
    }

    public void setProcess(XModelObject process) {
        this.constants.update();
        this.items.setProcess(process);
        this.apply();
        if (this.items.override) {
            TransitionArranger a = this.items.createTransitionArranger();
            a.setItems(this.items.items);
            a.execute();
        }
    }

    private void apply() {
        this.resetTransitions();
        Item[] is = this.items.items;
        int[] yDeltas = this.items.groups.yDeltas;
        int i = 0;
        while (i < is.length) {
            if (!is[i].isSet()) {
                XModelObject o = is[i].object;
                int x = is[i].ix * this.constants.deltaX + this.constants.indentX;
                int y = is[i].iy * this.constants.deltaY + this.constants.indentY;
                if (this.items.isZigzagging() && is[i].ix % 2 == 1) {
                    y += 16;
                }
                o.setAttributeValue("shape", (x += is[i].group.xDeltas[is[i].ix] * this.constants.incX) + "," + (y += yDeltas[is[i].iy] * this.constants.incY + is[i].yIndent) + ",0,0");
            }
            ++i;
        }
    }

    private void resetTransitions() {
        if (!this.items.override) {
            return;
        }
        Item[] is = this.items.items;
        int i = 0;
        while (i < is.length) {
            XModelObject o = is[i].object;
            if (o.getModelEntity().getAttribute("link shape") != null) {
                o.setAttributeValue("link shape", "");
            }
            XModelObject[] os = this.items.getOutput(o);
            int j = 0;
            while (j < os.length) {
                os[j].setAttributeValue("shape", "");
                ++j;
            }
            ++i;
        }
    }
}

