/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.jst.web.model.helpers.Registry;
import org.jboss.tools.jst.web.model.helpers.WebProcessUpdateHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProcessUpdateManager
implements XModelTreeListener {
    private HashMap<String, Registry> binds = new HashMap(1);
    private boolean active = true;

    protected WebProcessUpdateManager() {
    }

    public void register(String path, WebProcessUpdateHelper node) {
        HashMap<String, Registry> b = this.binds;
        while (path != null) {
            String[] q = this.reduce(path);
            Registry o = b.get(q[0]);
            if (o == null) {
                o = new Registry();
                b.put(q[0], o);
            }
            if ((path = q[1]) == null) {
                o.objects.add(node);
            }
            b = o.binds;
        }
    }

    public void unregister(String path, WebProcessUpdateHelper node) {
        HashMap<String, Registry> b = this.binds;
        while (path != null) {
            String[] q = this.reduce(path);
            Registry o = b.get(q[0]);
            if (o == null) {
                return;
            }
            path = q[1];
            if (path == null) {
                o.objects.remove(node);
            }
            b = o.binds;
        }
    }

    private String[] reduce(String path) {
        int i = path.indexOf(47);
        if (i <= 0) {
            String[] stringArray = new String[2];
            stringArray[0] = path.substring(i + 1);
            return stringArray;
        }
        return new String[]{path.substring(0, i), path.substring(i + 1)};
    }

    public Map<WebProcessUpdateHelper, String> getObjects(XModelTreeEvent event) {
        HashMap<WebProcessUpdateHelper, String> m = new HashMap<WebProcessUpdateHelper, String>();
        HashMap<String, Registry> b = this.binds;
        String np = event.getModelObject().getPath();
        String op = event.getInfo() instanceof String ? (String)event.getInfo() : np;
        Registry o = null;
        while (op != null) {
            String[] nq = np == null ? new String[2] : this.reduce(np);
            String[] oq = this.reduce(op);
            o = b.get(oq[0]);
            if (o == null) {
                return m;
            }
            if (nq[0] != null && !nq[0].equals(oq[0])) {
                b.remove(oq[0]);
                b.put(nq[0], o);
            }
            np = nq[1];
            op = oq[1];
            Iterator<WebProcessUpdateHelper> it = o.objects.iterator();
            while (it.hasNext()) {
                WebProcessUpdateHelper n = it.next();
                if (n == null) continue;
                if (!n.isActive()) {
                    it.remove();
                    continue;
                }
                m.put(n, op);
            }
            b = o.binds;
        }
        return m;
    }

    public void structureChanged(XModelTreeEvent event) {
        if (!this.active) {
            return;
        }
        XModel model = event.getModelObject().getModel();
        if (event.kind() == 3 && event.getModelObject() == model.getRoot()) {
            this.binds.clear();
            model.removeModelTreeListener((XModelTreeListener)this);
            this.active = false;
            return;
        }
        Map<WebProcessUpdateHelper, String> ps = this.getObjects(event);
        for (Map.Entry<WebProcessUpdateHelper, String> entry : ps.entrySet()) {
            WebProcessUpdateHelper helper = entry.getKey();
            helper.structureChanged(event, entry.getValue());
        }
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (!this.active) {
            return;
        }
        Map<WebProcessUpdateHelper, String> ps = this.getObjects(event);
        for (Map.Entry<WebProcessUpdateHelper, String> entry : ps.entrySet()) {
            WebProcessUpdateHelper helper = entry.getKey();
            helper.nodeChanged(event, entry.getValue());
        }
    }
}

