/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.WebProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaglibSet {
    XModel model;
    Map<String, String> uriToDescription = new HashMap<String, String>();
    Map<String, String> descriptionToUri = new HashMap<String, String>();
    Map<String, String> uriToPrefix = new HashMap<String, String>();

    public String[] getDescriptions() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.uriToDescription.values());
        return set.toArray(new String[0]);
    }

    public String getPrefix(String description) {
        String uri = this.getURIByDescription(description);
        return uri == null ? null : this.uriToPrefix.get(uri);
    }

    public void initTaglibDescriptions(XModel model) {
        this.model = model;
        this.uriToDescription.clear();
        this.descriptionToUri.clear();
        this.uriToPrefix.clear();
        HashMap<String, String> uriToDescriptionPalette = new HashMap<String, String>();
        XModelObject palette = PreferenceModelUtilities.getPreferenceModel().getByPath("%Palette%");
        if (palette == null) {
            return;
        }
        XModelObject[] tabs = palette.getChildren();
        int i = 0;
        while (i < tabs.length) {
            XModelObject[] gs = tabs[i].getChildren();
            int j = 0;
            while (j < gs.length) {
                String uri = gs[j].getAttributeValue("library uri");
                if (uri != null && uri.length() != 0) {
                    String description = String.valueOf(tabs[i].getAttributeValue("name")) + " " + gs[j].getAttributeValue("name");
                    uriToDescriptionPalette.put(uri, description);
                }
                ++j;
            }
            ++i;
        }
        if (this.isJSF()) {
            this.registerTaglib("http://java.sun.com/jsf/html", "h");
            this.registerTaglib("http://java.sun.com/jsf/core", "f");
        }
        WebProject p = WebProject.getInstance(model);
        Map<String, XModelObject> taglibObjects = p.getTaglibMapping().getTaglibObjects();
        for (String o : taglibObjects.keySet()) {
            String sn;
            XModelObject t;
            if (o == null) break;
            String s = o.toString();
            String string = s = s == null ? "" : s.trim();
            if (s.length() == 0 || (t = taglibObjects.get(s)) == null || (sn = t.getAttributeValue("shortname")) == null || sn.length() == 0) continue;
            String declaredURI = p.getTaglibMapping().getDeclaredURI(s);
            String description = t.getAttributeValue("description");
            if (description == null || description.length() == 0) {
                description = this.uriToDescription.get(s);
            }
            if (description == null || description.length() == 0 || description.length() >= 50) {
                description = (String)uriToDescriptionPalette.get(s);
            }
            if (description == null || description.length() == 0 || description.length() >= 50) {
                description = declaredURI != null ? declaredURI : s;
            }
            this.uriToDescription.put(s, description);
            this.descriptionToUri.put(description, s);
            if (declaredURI != null) {
                this.uriToDescription.put(declaredURI, description);
                this.descriptionToUri.put(description, declaredURI);
            }
            if (declaredURI == null) {
                this.registerTaglib(s, sn);
                continue;
            }
            this.registerTaglib(declaredURI, sn);
        }
    }

    private void registerTaglib(String uri, String prefix) {
        this.uriToPrefix.put(uri, prefix);
    }

    String getTaglibDescription(String uri) {
        String description = this.uriToDescription.get(uri);
        return description != null ? description : uri;
    }

    String getURIByDescription(String description) {
        String uri = this.descriptionToUri.get(description);
        return uri != null ? uri : description;
    }

    public final Set<String> getTaglibsFromTemplate(String body) {
        HashSet<String> existing = new HashSet<String>();
        this.doGetTaglibsFromTemplate(body, existing);
        return existing;
    }

    protected void doGetTaglibsFromTemplate(String body, Set<String> existing) {
        StringTokenizer st = new StringTokenizer(body, "\n");
        while (st.hasMoreTokens()) {
            int e;
            int b;
            String t = st.nextToken().trim();
            if (!t.startsWith("<%@ taglib") || !t.endsWith("%>") || (b = t.indexOf("uri=\"")) < 0 || (e = t.indexOf("\"", b += 5)) < 0) continue;
            String uri = t.substring(b, e);
            b = t.indexOf("prefix=\"");
            if ((b += 8) < 0 || (e = t.indexOf("\"", b)) < 0) continue;
            String prefix = t.substring(b, e);
            this.appendURIFound(prefix, uri, existing);
        }
    }

    protected final void appendURIFound(String prefix, String uri, Set<String> existing) {
        String description = this.getTaglibDescription(uri);
        this.uriToDescription.put(uri, description);
        this.descriptionToUri.put(description, uri);
        this.uriToPrefix.put(uri, prefix);
        existing.add(uri);
    }

    boolean isJSF() {
        return EclipseResourceUtil.hasNature((XModel)this.model, (String)"org.jboss.tools.jsf.jsfnature");
    }

    public final String modifyBody(String body, String[] selected) {
        StringBuffer sb = new StringBuffer();
        boolean b = this.doModifyBody(body, selected, sb);
        return b ? sb.toString() : body;
    }

    protected boolean doModifyBody(String body, String[] selected, StringBuffer sb) {
        int i = 0;
        while (i < selected.length) {
            String uri = this.getURIByDescription(selected[i]);
            String prefix = this.getPrefix(selected[i]);
            sb.append("<%@ taglib uri=\"" + uri + "\"" + " prefix=\"" + prefix + "\"" + " %>\n");
            ++i;
        }
        body = this.remove(body, "<%@ taglib", "%>");
        sb.append(body);
        return true;
    }

    private String remove(String body, String start, String end) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        block0: while (true) {
            int ib;
            int ie;
            int n = ie = (ib = body.indexOf(start, i)) < 0 ? -1 : body.indexOf(end, ib);
            if (ie < 0) break;
            sb.append(body.substring(i, ib));
            i = ie + end.length();
            while (true) {
                if (i >= body.length() || body.charAt(i) != '\r' && body.charAt(i) != '\n') continue block0;
                ++i;
            }
            break;
        }
        sb.append(body.substring(i));
        return sb.toString();
    }
}

