/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.handlers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.CreateFileSupport;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.ClassLoaderUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.model.handlers.TaglibSet;
import org.jboss.tools.jst.web.model.handlers.TaglibSetXHTML;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.TaglibMapping;

public class CreateJSPFileSupport
extends CreateFileSupport {
    protected Map<String, File> templates = new TreeMap<String, File>();
    TaglibSet taglibs;
    private static final String NewJSFProjectPath = "%Options%/JSF Studio/Project/New Project";
    private static final String NewStrutsProjectPath = "%Options%/Struts Studio/Project/New Project";
    private Map<String, String> selectedTaglibs = new HashMap<String, String>();

    static {
        ClassLoaderUtil.init();
    }

    public void reset() {
        this.taglibs = null;
        this.selectedTaglibs.clear();
        if (this.getEntityData().length > 1) {
            this.resetTaglibs();
        }
        super.reset();
    }

    public String[] getActionNames(int stepId) {
        if (stepId == 0) {
            if (this.getEntityData().length == 1 || this.taglibs == null) {
                return super.getActionNames(stepId);
            }
            return new String[]{NEXT, FINISH, CANCEL, HELP};
        }
        return new String[]{BACK, FINISH, CANCEL, HELP};
    }

    public void action(String name) throws XModelException {
        if (NEXT.equals(name)) {
            try {
                this.initSelectedTaglibs();
            }
            catch (IOException e) {
                throw new XModelException((Throwable)e);
            }
            this.setStepId(1);
        } else if (BACK.equals(name)) {
            this.saveSelectedTaglibs();
            this.setStepId(0);
        } else {
            super.action(name);
        }
    }

    public String[] getPageTemplateList() {
        this.templates.clear();
        File templateDir = new File(this.getPageTemplatesLocation());
        if (!templateDir.isDirectory()) {
            return new String[0];
        }
        this.getTemplates(templateDir);
        String nature = this.getTarget().getModel().getProperties().getProperty("nature");
        if (nature != null) {
            if (nature.indexOf("jsf") >= 0) {
                this.getTemplates(templateDir, "jsf");
            } else if (nature.indexOf("struts") >= 0) {
                this.getTemplates(templateDir, "struts");
            }
        }
        return this.templates.keySet().toArray(new String[0]);
    }

    protected String getDefaultPageTemplate() {
        String prefPath;
        String defaultPageTemplate = null;
        String nature = this.getTarget().getModel().getProperties().getProperty("nature");
        if (nature == null) {
            return null;
        }
        String string = nature.indexOf("jsf") >= 0 ? NewJSFProjectPath : (prefPath = nature.indexOf("struts") >= 0 ? NewStrutsProjectPath : null);
        if (prefPath == null) {
            return null;
        }
        XModelObject pref = PreferenceModelUtilities.getPreferenceModel().getByPath(prefPath);
        if (pref == null) {
            WebModelPlugin.getPluginLog().logError("Cannot find preference object " + prefPath, (Throwable)new Exception());
            return null;
        }
        defaultPageTemplate = pref.getAttributeValue("Page Template");
        return defaultPageTemplate;
    }

    protected File findTemplate(String template) {
        return this.templates.get(template);
    }

    public String getPageTemplatesLocation() {
        return String.valueOf(this.getTemplatesBase()) + "/pages";
    }

    private void getTemplates(File parent, String name) {
        File dir = new File(parent, name);
        if (dir.isDirectory()) {
            this.getTemplates(dir);
        }
    }

    private void getTemplates(File dir) {
        String ext = this.action.getProperty("extension");
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String n = files[i].getName();
                if (ext == null || n.endsWith("." + ext) || ext.equals("jsp") && n.indexOf(46) < 0) {
                    this.templates.put(n, files[i]);
                }
            }
            ++i;
        }
    }

    private String getTemplatesBase() {
        String root = WebModelPlugin.getTemplateStateLocation();
        return String.valueOf(root) + "templates";
    }

    public WizardDataValidator getValidator(int step) {
        if (step == 1) {
            this.defaultValidator.setSupport((SpecialWizardSupport)this, step);
            return this.defaultValidator;
        }
        return super.getValidator(step);
    }

    private void saveSelectedTaglibs() {
        String template = this.getAttributeValue(0, "template");
        if (template == null) {
            return;
        }
        String taglibs = this.getAttributeValue(1, "taglibs");
        if (taglibs != null) {
            this.selectedTaglibs.put(template.trim(), taglibs);
        }
    }

    private void resetTaglibs() {
        TaglibMapping m;
        String extension = this.action.getProperty("extension");
        if ("jsp".equals(extension)) {
            this.taglibs = new TaglibSet();
        } else if ("xhtml".equals(extension)) {
            this.taglibs = new TaglibSetXHTML();
        } else {
            return;
        }
        XModel model = this.getTarget().getModel();
        XModelObject web = WebAppHelper.getWebApp(model);
        if (web != null && (m = WebProject.getInstance(model).getTaglibMapping()) != null) {
            m.revalidate(web);
        }
        this.taglibs.initTaglibDescriptions(model);
        String[] s = this.taglibs.getDescriptions();
        this.setValueList(1, "taglibs", s);
    }

    void initSelectedTaglibs() throws IOException {
        String value;
        String template = this.getAttributeValue(0, "template");
        String string = value = template == null ? null : this.selectedTaglibs.get(template.trim());
        if (value != null && template.trim().length() > 0) {
            this.setAttributeValue(1, "taglibs", value);
            return;
        }
        String body = this.getTemplateBody();
        Set<String> existing = this.taglibs.getTaglibsFromTemplate(body);
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = existing.iterator();
        while (it.hasNext()) {
            String s = it.next().toString();
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(this.taglibs.getTaglibDescription(s));
        }
        value = sb.toString();
        this.setAttributeValue(1, "taglibs", value);
    }

    protected String modifyBody(String body) throws IOException {
        if (this.getEntityData().length < 2 || this.taglibs == null) {
            return body;
        }
        if (this.getStepId() == 0) {
            this.initSelectedTaglibs();
        }
        String ts = this.getAttributeValue(1, "taglibs");
        String[] selected = this.toArray(ts);
        return this.taglibs.modifyBody(body, selected);
    }

    String[] toArray(String s) {
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, ";,");
        String[] a = new String[st.countTokens()];
        int i = 0;
        while (i < a.length) {
            a[i] = st.nextToken();
            ++i;
        }
        return a;
    }
}

