/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.context;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.Messages;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.server.RegistrationHelper;
import org.jboss.tools.jst.web.server.ServerManager;

public class RegisterServerContext {
    public static int PROJECT_MODE_NEW = 0;
    public static int PROJECT_MODE_IMPORT = 1;
    public static int PROJECT_MODE_EXISTING = 2;
    static String HELP_KEY_BASE = "FileSystems_RegisterInServerXML";
    IProject project = null;
    String servletVersion = "";
    int mode;
    boolean isEnabled = false;
    boolean isInitiallyEnabled = false;
    String location = null;
    String applicationName = null;
    String natureIndex = null;
    Preference registerProjectPreference;
    IRuntime runtime = null;
    String runtimeName = "";
    IServer[] targetServers = new IServer[0];
    long xmlTimeStamp = -1L;
    String xmlError = null;
    private static final String YES_STRING = "yes";
    private static final String EMPTY_LOCATION = "";

    public RegisterServerContext(int mode) {
        this.mode = mode;
        this.init();
    }

    public void setServletVersion(String v) {
        this.servletVersion = v;
    }

    public String getServletVersion() {
        return this.servletVersion;
    }

    public void setProjectHandle(IProject p) {
        this.project = p;
    }

    public IProject getProjectHandle() {
        return this.project;
    }

    public void setPreferences(Preference registerProjectPreference) {
        this.registerProjectPreference = registerProjectPreference;
    }

    public void setNatureIndex(String n) {
        this.natureIndex = n;
    }

    public void setRuntimeName(String runtimeName) {
        if (this.runtimeName.equals(this.runtime)) {
            return;
        }
        this.runtimeName = runtimeName;
        IRuntime[] rs = ServerCore.getRuntimes();
        int i = 0;
        while (i < rs.length) {
            if (rs[i].getName().equals(runtimeName)) {
                this.runtime = rs[i];
                return;
            }
            ++i;
        }
        this.runtime = null;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public void setTargetServers(IServer[] info) {
        this.targetServers = info;
    }

    public IServer[] getTargetServers() {
        return this.targetServers;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = this.mode == PROJECT_MODE_EXISTING || b;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isInitiallyEnabled() {
        return this.isInitiallyEnabled;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getErrorMessage() {
        if (this.runtimeName == null || this.runtimeName.length() == 0) {
            return WebUIMessages.RUNTIME_IS_REQUIRED;
        }
        if (this.runtime == null) {
            return WebUIMessages.SPECIFIED_RUNTIME_DOESNOT_EXIST;
        }
        if (!this.isEnabled()) {
            if (this.servletVersion != null && this.servletVersion.length() == 0) {
                return Messages.ERR_SERVLET_VERSION_IS_NOT_SET;
            }
            return null;
        }
        if (this.applicationName == null || this.applicationName.length() == 0) {
            return Messages.ERR_APP_NAME_IS_NOT_SPECIFIED;
        }
        String contextRootError = RegistrationHelper.checkContextRoot(this.applicationName);
        if (contextRootError != null) {
            return contextRootError;
        }
        int i = 0;
        while (i < this.targetServers.length) {
            if (RegistrationHelper.isRegistered(this.applicationName, this.targetServers[i])) {
                return NLS.bind((String)WebUIMessages.APPLICATION_IS_ALREADY_REGISTERED, (Object)this.applicationName, (Object)this.targetServers[i].getName());
            }
            if (this.project != null && this.servletVersion != null && this.servletVersion.length() > 0) {
                String m;
                if (this.project.exists() && RegistrationHelper.isRegistered(this.project)) {
                    return MessageFormat.format(WebUIMessages.PROJECT_IS_ALREADY_REGISTERED, this.project.getName());
                }
                ModuleFactory f = ServerPlugin.findModuleFactory((String)"org.eclipse.jst.j2ee.server");
                IModule module = RegistrationHelper.findModule(this.project);
                if (module == null) {
                    module = f == null ? null : new Module(f, this.project.getName(), this.project.getName(), "jst.web", this.servletVersion, null);
                }
                String string = m = module == null ? null : RegistrationHelper.getRegistrationError(module, this.applicationName, this.targetServers[i]);
                if (m != null) {
                    return m;
                }
            }
            ++i;
        }
        if (this.servletVersion != null && this.servletVersion.length() == 0) {
            return Messages.ERR_SERVLET_VERSION_IS_NOT_SET;
        }
        if (!this.checkServletVersionFormat()) {
            return Messages.ERR_SERVLET_VERSION_IS_NOT_VALID;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    boolean checkServletVersionFormat() {
        if (this.servletVersion == null || this.servletVersion.length() == 0) {
            return true;
        }
        st = new StringTokenizer(this.servletVersion, ".");
        if (st.countTokens() >= 2 && st.countTokens() <= 3) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            t = st.nextToken().trim();
            try {
                Integer.parseInt(t);
                continue;
            }
            catch (NumberFormatException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
                return false;
            }
lbl14:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl15:
        // 1 sources

        return true;
    }

    public void init() {
        this.isInitiallyEnabled = this.isEnabled = this.registerProjectPreference == null || YES_STRING.equals(this.registerProjectPreference.getValue());
        this.applicationName = null;
        IServer server = ServerManager.getInstance().getSelectedServer();
        this.location = server == null || server.getRuntime() == null ? EMPTY_LOCATION : server.getRuntime().getLocation().toString();
    }

    public int getMode() {
        return this.mode;
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public String getHelpBase() {
        return this.natureIndex == null ? HELP_KEY_BASE : String.valueOf(HELP_KEY_BASE) + "_" + this.natureIndex;
    }
}

