/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.Messages;
import org.jboss.tools.common.xml.ErrorHandlerImpl;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtilities {
    public static final EntityResolver EMPTY_RESOLVER = XMLUtilities.createEmptyEntityResolver();
    static final String ENCODING = "encoding=\"";
    static final String UTF8 = "UTF-8";

    public static boolean hasAttribute(Element e, String s) {
        return e.getAttributes().getNamedItem(s) != null;
    }

    public static Element[] getChildren(Element parent, String name) {
        ArrayList<Element> al = new ArrayList<Element>();
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(name)) {
                al.add((Element)n);
            }
            ++i;
        }
        return al.toArray(new Element[0]);
    }

    public static Element getUniqueChild(Element parent, String name) {
        Element[] e = XMLUtilities.getChildren(parent, name);
        return e.length == 0 ? null : e[0];
    }

    public static Element getFirstChild(Element parent, String name) {
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(name)) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static Element getLastChild(Element parent, String name) {
        Element child = null;
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(name)) {
                child = (Element)n;
            }
            ++i;
        }
        return child;
    }

    public static Element[] getAncestors(Element parent, String name) {
        int i = name.indexOf(46);
        if (i < 0) {
            return XMLUtilities.getChildren(parent, name);
        }
        Element p = XMLUtilities.getUniqueChild(parent, name.substring(0, i));
        return p == null ? new Element[]{} : XMLUtilities.getAncestors(p, name.substring(i + 1));
    }

    public static Element createElement(Element parent, String path) {
        int i = path.indexOf(46);
        if (i < 0) {
            Element element = parent.getOwnerDocument().createElement(path);
            parent.appendChild(element);
            return element;
        }
        String p = path.substring(0, i);
        String c = path.substring(i + 1);
        Element pe = XMLUtilities.getUniqueChild(parent, p);
        if (pe == null) {
            pe = parent.getOwnerDocument().createElement(p);
            parent.appendChild(pe);
        }
        return XMLUtilities.createElement(pe, c);
    }

    public static DocumentBuilder createDocumentBuilder() {
        return XMLUtilities.createDocumentBuilder(false);
    }

    public static DocumentBuilder createDocumentBuilder(boolean validate) {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            if (validate) {
                f.setValidating(validate);
            }
            DocumentBuilder d = f.newDocumentBuilder();
            if (!validate) {
                d.setEntityResolver(EMPTY_RESOLVER);
            }
            d.setErrorHandler(new ErrorHandlerImpl());
            return d;
        }
        catch (ParserConfigurationException e) {
            CommonPlugin.getPluginLog().logError(e);
            return null;
        }
    }

    public static Element createDocumentElement(String name) {
        Document d = XMLUtilities.createDocumentBuilder().newDocument();
        Element de = d.createElement(name);
        d.appendChild(de);
        return de;
    }

    public static EntityResolver createEmptyEntityResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId != null && systemId.toLowerCase().endsWith(".dtd")) {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return null;
            }
        };
    }

    public static Element createDocumentElement(String name, String qName, String publicId, String systemId, String namespaceURI) {
        Document d = null;
        try {
            DOMImplementation domImpl = XMLUtilities.createDocumentBuilder().getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType(qName, publicId, systemId);
            d = domImpl.createDocument(namespaceURI, name, docType);
        }
        catch (DOMException dOMException) {
            return null;
        }
        Element de = d.getDocumentElement();
        if (de == null) {
            de = d.createElement(name);
            d.appendChild(de);
        }
        return de;
    }

    public static Element getElement(String filename, EntityResolver resolver) {
        return XMLUtilities.getElement(new File(filename), resolver);
    }

    public static Element getElement(File file, EntityResolver resolver) {
        if (file == null || !file.isFile()) {
            return null;
        }
        FileReader fr = null;
        try {
            fr = new FileReader(file);
            InputSource inSource = new InputSource(fr);
            Element element = XMLUtilities.getElement(inSource, resolver);
            return element;
        }
        catch (FileNotFoundException e) {
            CommonPlugin.getPluginLog().logError(e);
        }
        catch (IOException e) {
            CommonPlugin.getPluginLog().logError(e);
        }
        catch (SAXException e) {
            CommonPlugin.getPluginLog().logError(e);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                CommonPlugin.getPluginLog().logError(e);
            }
        }
        return null;
    }

    public static Element getElement(Reader reader, EntityResolver resolver) {
        Document d = XMLUtilities.getDocument(reader, resolver);
        return d == null ? null : d.getDocumentElement();
    }

    public static Document getDocument(Reader reader, EntityResolver resolver) {
        try {
            InputSource inSource = new InputSource(reader);
            return XMLUtilities.getDocument(inSource, resolver);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Element getElement(InputStream is, EntityResolver resolver) {
        try {
            InputSource inSource = new InputSource(is);
            return XMLUtilities.getElement(inSource, resolver);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Element getElement(InputSource is, EntityResolver resolver) throws SAXException, IOException {
        return XMLUtilities.getDocument(is, resolver).getDocumentElement();
    }

    public static Document getDocument(InputSource is, EntityResolver resolver) throws SAXException, IOException {
        DocumentBuilder builder = XMLUtilities.createDocumentBuilder(false);
        if (resolver != null) {
            builder.setEntityResolver(resolver);
        }
        return builder.parse(is);
    }

    public static String[] getXMLErrors(Reader reader, EntityResolver resolver) {
        return XMLUtilities.getXMLErrors(reader, true, resolver);
    }

    public static String[] getXMLErrors(Reader reader, boolean checkDTD, EntityResolver resolver) {
        InputSource inSource = new InputSource(reader);
        return XMLUtilities.getXMLErrors(inSource, checkDTD, resolver);
    }

    public static String[] getXMLErrors(InputSource is, EntityResolver resolver) {
        return XMLUtilities.getXMLErrors(is, true, resolver);
    }

    public static String[] getXMLErrors(InputSource is, boolean checkDTD, EntityResolver resolver) {
        ErrorHandlerImpl h;
        block5: {
            h = new ErrorHandlerImpl();
            try {
                DocumentBuilder builder = XMLUtilities.createDocumentBuilder(checkDTD);
                if (resolver != null) {
                    builder.setEntityResolver(resolver);
                }
                builder.setErrorHandler(h);
                builder.parse(is);
            }
            catch (IOException e) {
                if (h.errors.isEmpty()) {
                    return new String[]{String.valueOf(Messages.XMLUtilities_IOExceptionMessage) + ":0:0", e.toString()};
                }
            }
            catch (SAXException e) {
                if (!h.errors.isEmpty()) break block5;
                return new String[]{String.valueOf(Messages.XMLUtilities_SAXExceptionMessage) + ":0:0", e.toString()};
            }
        }
        return h.errors.toArray(new String[0]);
    }

    public static final void serialize(Element element, String filename) throws IOException {
        File f = new File(filename);
        if (f.exists() && !f.canWrite()) {
            return;
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f);
        XMLUtilities.serialize(element, (Writer)new BufferedWriter(fw));
        fw.close();
    }

    public static String getEncoding(String body) {
        int i = body.indexOf(ENCODING);
        if (i < 0) {
            return UTF8;
        }
        int j = body.indexOf(34, i += ENCODING.length());
        if (j < 0) {
            return UTF8;
        }
        return body.substring(i, j);
    }

    public static OutputFormat createOutputFormat(String encoding) {
        OutputFormat format = new OutputFormat("xml", encoding == null || encoding.length() == 0 ? null : encoding, true);
        format.setLineSeparator(System.getProperty("line.separator", "\n"));
        format.setIndent(1);
        return format;
    }

    public static final boolean serialize(Element element, Writer w) throws IOException {
        if (element == null) {
            return false;
        }
        XMLUtilities.serialize(element, new XMLSerializer(w, XMLUtilities.createOutputFormat(UTF8)));
        w.close();
        return true;
    }

    public static final boolean serialize(Element element, OutputStream w) throws IOException {
        if (element == null) {
            return false;
        }
        XMLUtilities.serialize(element, new XMLSerializer(w, XMLUtilities.createOutputFormat(UTF8)));
        w.close();
        return true;
    }

    public static void serialize(Element element, XMLSerializer serial) throws IOException {
        serial.asDOMSerializer();
        serial.serialize(element);
    }

    public static void serialize(Document document, XMLSerializer serial) throws IOException {
        if (serial == null || document == null) {
            return;
        }
        serial.asDOMSerializer();
        serial.serialize(document);
    }

    public static final boolean serialize(Document document, Writer w) throws IOException {
        return XMLUtilities.serialize(document, w, null);
    }

    public static final boolean serialize(Document document, Writer w, String encoding) throws IOException {
        if (document == null) {
            return false;
        }
        XMLUtilities.serialize(document, new XMLSerializer(w, XMLUtilities.createOutputFormat(encoding)));
        w.close();
        return true;
    }

    public static final String getCDATA(Element elem) {
        return XMLUtilities.getCDATA(elem, true);
    }

    public static final String getCDATA(Element elem, boolean trim) {
        StringBuffer sb = new StringBuffer();
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node nc = nl.item(i);
            if (nc.getNodeType() == 4) {
                sb.append(((Text)nc).getData());
            } else if (nc.getNodeType() == 3) {
                String txt = ((Text)nc).getData();
                if (trim) {
                    txt = txt.trim();
                }
                sb.append(txt);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String getComment(Element elem) {
        StringBuffer sb = new StringBuffer();
        Node node = elem.getPreviousSibling();
        while (node != null) {
            if (node.getNodeType() == 1) break;
            if (node.getNodeType() == 8) {
                if (sb.length() > 0) {
                    sb.insert(0, '\n');
                    sb.insert(0, ((Comment)node).getData());
                } else {
                    sb.append(((Comment)node).getData());
                }
            }
            node = node.getPreviousSibling();
        }
        return sb.toString();
    }

    public static final void setCDATA(Element element, String data) {
        element.appendChild(element.getOwnerDocument().createCDATASection(data != null ? data : ""));
    }

    public static final void setText(Element element, String data) {
        element.appendChild(element.getOwnerDocument().createTextNode(data != null ? data : ""));
    }

    public static final void setComment(Element element, String data) {
        Comment comm = element.getOwnerDocument().createComment(data != null ? data : "");
        element.getParentNode().insertBefore(comm, element);
    }
}

