/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.xml.ErrorHandlerImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SafeDocumentBuilderFactory
extends Thread {
    public static final EntityResolver EMPTY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null && systemId.toLowerCase().endsWith(".dtd")) {
                return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
            }
            return null;
        }
    };
    DocumentBuilder d = null;
    boolean validate = false;

    private SafeDocumentBuilderFactory(boolean validate) {
        this.validate = validate;
    }

    public void run() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                if (this.validate) {
                    f.setValidating(this.validate);
                }
                this.d = f.newDocumentBuilder();
                if (!this.validate) {
                    this.d.setEntityResolver(EMPTY_RESOLVER);
                }
                this.d.setErrorHandler(new ErrorHandlerImpl());
            }
            catch (ParserConfigurationException e) {
                CommonPlugin.getPluginLog().logError(e);
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static DocumentBuilder createDocumentBuilder(boolean validating) {
        SafeDocumentBuilderFactory t = new SafeDocumentBuilderFactory(validating);
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException interruptedException) {
            t.run();
        }
        return t.d;
    }
}

