/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.osgi.framework.Bundle;

public class ResourcesUtils {
    public static IProject importProject(Bundle bundle, String templLocation, IProgressMonitor monitor) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        String tplPrjLcStr = FileLocator.resolve((URL)bundle.getEntry(templLocation)).getFile();
        return ResourcesUtils.importProject(tplPrjLcStr, monitor);
    }

    public static IProject importProject(String location, IProgressMonitor monitor) throws CoreException, IOException, InvocationTargetException, InterruptedException {
        IProject importedPrj = ResourcesUtils.createEclipseProjectDromDescriptor(location, monitor);
        ImportOperation op = new ImportOperation(importedPrj.getFullPath(), (Object)new File(location), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                return "ALL";
            }
        }, Arrays.asList(new File(location).listFiles()));
        op.setCreateContainerStructure(false);
        op.run(monitor);
        return importedPrj;
    }

    public static IProject importExistingProject(IProject project, String location, String name) throws CoreException {
        return ResourcesUtils.importExistingProject(project, location, name, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public static IProject importExistingProject(IProject project, String location, String name, IProgressMonitor monitor, boolean refreshWorkspace) throws CoreException {
        IPath path = new Path(location).append(".project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(path);
        description.setName(name);
        project.create(description, monitor);
        project.open(0, monitor);
        if (refreshWorkspace) {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    public static IProject createEclipseProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject newProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        newProjectHandle.create(description, (IProgressMonitor)new NullProgressMonitor());
        newProjectHandle.open(monitor);
        return newProjectHandle;
    }

    public static IProject createEclipseProjectDromDescriptor(String templateLocation, IProgressMonitor monitor) throws CoreException, IOException {
        IPath tplPrjDescr = new Path(templateLocation).append(".project");
        IProjectDescription descr = ResourcesPlugin.getWorkspace().loadProjectDescription(tplPrjDescr);
        descr.setLocation(null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(descr.getName());
        project.create(descr, monitor);
        project.open(128, monitor);
        return project;
    }
}

