/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text;

import java.util.Comparator;
import org.eclipse.swt.graphics.Image;

public class TextProposal {
    public static final int R_NONE = 0;
    public static final int R_JSP_JSF_EL_VARIABLE_ATTRIBUTE_VALUE = 810;
    public static final int R_JSP_ATTRIBUTE_VALUE = 830;
    public static final int R_XML_ATTRIBUTE_VALUE = 850;
    public static final int R_XML_ATTRIBUTE_NAME = 910;
    public static final int R_TAG_INSERTION = 500;
    public static final int R_XML_ATTRIBUTE_VALUE_TEMPLATE = 91;
    public static final int R_CLOSE_TAG = 1550;
    private static final long serialVersionUID = 3257007635692926512L;
    private Object source;
    private String label;
    private String contextInfo;
    private Image image;
    private boolean emptyImage = true;
    private String replacementString;
    private boolean emptyContextInfo = true;
    private int relevance = 0;
    private int position = -1;
    private boolean autoActivationContentAssistantAfterApplication = false;
    private String type;
    private String sourceType;
    private int start = -1;
    private int end = -1;
    PostProcessing postProcessing;
    public static final Comparator<TextProposal> KB_PROPOSAL_ORDER = new TextProposalComparator();

    public String getType() {
        return this.type;
    }

    public void setType(String typeName) {
        this.type = typeName;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceTypeName) {
        this.sourceType = sourceTypeName;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int relevance) {
        this.relevance = relevance;
    }

    public String getContextInfo() {
        return this.contextInfo;
    }

    public Image getImage() {
        return this.image;
    }

    public String getLabel() {
        String l = this.label != null ? this.label : (this.getReplacementString() == null ? "" : this.getReplacementString());
        StringBuffer dispLabel = new StringBuffer(l);
        if (this.type != null) {
            dispLabel.append(" : ");
            dispLabel.append(this.type);
        }
        if (this.sourceType != null) {
            dispLabel.append(" - ");
            dispLabel.append(this.sourceType);
        }
        return dispLabel.toString();
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setContextInfo(String string) {
        this.contextInfo = string;
        if (this.contextInfo != null) {
            this.emptyContextInfo = false;
        }
    }

    public void setImage(Image img) {
        this.image = img;
        if (this.image != null) {
            this.emptyImage = false;
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setReplacementString(String string) {
        this.replacementString = string;
    }

    public boolean hasContextInfo() {
        return !this.emptyContextInfo;
    }

    public boolean hasImage() {
        return !this.emptyImage;
    }

    public int getPosition() {
        if (this.position == -1 && this.getReplacementString() != null) {
            return this.getReplacementString().length();
        }
        return this.position;
    }

    public void setPosition(int i) {
        this.position = i;
    }

    public void changeCase(boolean lowerCase) {
        if (lowerCase) {
            if (this.label != null) {
                this.label = this.label.toLowerCase();
            }
            if (this.replacementString != null) {
                this.replacementString = this.replacementString.toLowerCase();
            }
        } else {
            if (this.label != null) {
                this.label = this.label.toUpperCase();
            }
            if (this.replacementString != null) {
                this.replacementString = this.replacementString.toUpperCase();
            }
        }
    }

    public void removeAutocompleteRequiredAttributes() {
        int endAttr = this.replacementString.lastIndexOf(34);
        if (endAttr != -1) {
            int startAttr = this.replacementString.substring(0, this.replacementString.indexOf(34)).lastIndexOf(32);
            String newReplacementString = this.replacementString.substring(0, startAttr);
            if (endAttr + 1 < this.replacementString.length()) {
                newReplacementString = String.valueOf(newReplacementString) + this.replacementString.substring(endAttr + 1);
            }
            this.replacementString = newReplacementString;
        }
    }

    public boolean isCloseTag() {
        return this.label != null && this.label.startsWith("/");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("label: ");
        buffer.append(this.label);
        buffer.append("\ncontextInfo: ");
        buffer.append(this.contextInfo);
        buffer.append("\nreplacementString: ");
        buffer.append(this.replacementString);
        return buffer.toString();
    }

    public int compareTo(Object o) {
        return this.label.compareTo(((TextProposal)o).getLabel());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextProposal) || obj == null) {
            return false;
        }
        TextProposal anotherProposal = (TextProposal)obj;
        boolean labelB = false;
        boolean contextInfoB = false;
        boolean replacementStringB = false;
        if (this.label != null) {
            labelB = this.label.equals(anotherProposal.getLabel());
        } else if (anotherProposal.getLabel() == null) {
            labelB = true;
        }
        if (this.contextInfo != null) {
            contextInfoB = this.contextInfo.equals(anotherProposal.getContextInfo());
        } else if (anotherProposal.getContextInfo() == null) {
            contextInfoB = true;
        }
        if (this.replacementString != null) {
            replacementStringB = this.replacementString.equals(anotherProposal.getReplacementString());
        } else if (anotherProposal.getReplacementString() == null) {
            replacementStringB = true;
        }
        return labelB && contextInfoB && replacementStringB;
    }

    public boolean autoActivationContentAssistantAfterApplication() {
        return this.autoActivationContentAssistantAfterApplication;
    }

    public void setAutoActivationContentAssistantAfterApplication(boolean autoActivationContentAssistantAfterApplication) {
        this.autoActivationContentAssistantAfterApplication = autoActivationContentAssistantAfterApplication;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setPostProcessing(PostProcessing postProcessing) {
        this.postProcessing = postProcessing;
    }

    public void postProcess(String value, int offset) {
        if (this.postProcessing != null) {
            this.postProcessing.process(this, value, offset);
        }
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public static interface PostProcessing {
        public void process(TextProposal var1, String var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextProposalComparator
    implements Comparator<TextProposal> {
        private TextProposalComparator() {
        }

        @Override
        public int compare(TextProposal p1, TextProposal p2) {
            int n1 = p1.replacementString.length();
            int n2 = p2.replacementString.length();
            int i1 = 0;
            int i2 = 0;
            while (i1 < n1 && i2 < n2) {
                char c2;
                char c1 = p1.replacementString.charAt(i1);
                if (c1 != (c2 = p2.replacementString.charAt(i2)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++i1;
                ++i2;
            }
            return n1 - n2;
        }
    }
}

