/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.reporting;

import java.io.File;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.jboss.tools.common.reporting.Submit;
import org.jboss.tools.common.util.FileUtil;
import org.osgi.framework.Bundle;

public class ProblemBuffer {
    FrameworkLog log;
    ILogListener writer;

    ProblemBuffer() {
    }

    public void writeToBuffer(IStatus status) {
        this.getEclipseLog();
        this.writer.logging(status, "org.jboss.tools.common");
    }

    public int getSize() {
        String s = this.getContent();
        if (s.length() == 0) {
            return 0;
        }
        int i = 0;
        int c = 0;
        while (i < s.length()) {
            if ((i = s.indexOf("!ENTRY", i)) < 0) break;
            ++c;
            ++i;
        }
        return c;
    }

    public String getContent() {
        File f = this.getLogFile();
        return !f.isFile() ? "" : FileUtil.readFile(f);
    }

    public String getEclipseLogContent() {
        File f = Platform.getLogFileLocation().toFile();
        return f.isFile() ? FileUtil.readFile(f) : "";
    }

    public void clean() {
        File f = this.getLogFile();
        if (f.exists()) {
            f.delete();
        }
    }

    public void report(String text, String userEMail, String other, boolean cleanBuffer) {
        StringBuffer sb = new StringBuffer();
        if (userEMail != null && userEMail.trim().length() > 0) {
            sb.append("Customer e-mail=" + userEMail + "\n");
        }
        if (other != null && other.length() > 0) {
            sb.append("Other=" + other + "\n");
        }
        if (text != null) {
            sb.append(text);
        }
        String reportText = sb.toString();
        Submit.getInstance().submit(reportText, cleanBuffer);
    }

    private FrameworkLog getEclipseLog() {
        if (this.log == null) {
            this.log = new EclipseLog(this.getLogFile());
            this.writer = new PlatformLogWriter(this.log);
        }
        return this.log;
    }

    private File getLogFile() {
        Bundle b = Platform.getBundle((String)"org.jboss.tools.common");
        String stateLocation = Platform.getStateLocation((Bundle)b).toString().replace('\\', '/');
        String logLocation = String.valueOf(stateLocation) + "/.log";
        return new File(logLocation);
    }
}

