/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.taglib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

public class TagLibraryManager {
    public static ITagLibrary[] getLibraries(IProject project, String uri) {
        IKbProject kbProject = KbProjectFactory.getKbProject(project, true);
        if (kbProject == null) {
            return new ITagLibrary[0];
        }
        return uri == null ? kbProject.getTagLibraries() : kbProject.getTagLibraries(uri);
    }

    public static ITagLibrary[] getLibraries(IProject project) {
        return TagLibraryManager.getLibraries(project, null);
    }

    public static File getStaticTLD(String uri) {
        try {
            if (uri != null) {
                File file;
                String id = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveURI(uri);
                if (id == null) {
                    id = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolveSystem(uri);
                }
                if (id == null) {
                    id = XMLCorePlugin.getDefault().getDefaultXMLCatalog().resolvePublic(uri, uri);
                }
                if (id != null && (file = new File(new URL(id).getFile())).exists()) {
                    return file;
                }
            }
        }
        catch (IOException e) {
            WebKbPlugin.getDefault().logError(e);
            return null;
        }
        return null;
    }
}

