/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.taglib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.HTMLTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CustomTagLibManager {
    public static final String FACELETS_UI_TAG_LIB_URI = "http://java.sun.com/jsf/facelets";
    public static final String FACELETS_HTML_TAG_LIB_URI = "http://www.w3.org/1999/xhtml/facelets";
    private static final CustomTagLibManager INSTANCE = new CustomTagLibManager();
    private ICustomTagLibrary[] libs = null;
    private CustomTagLibAttribute[] extensions = null;

    private CustomTagLibManager() {
    }

    public static CustomTagLibManager getInstance() {
        return INSTANCE;
    }

    public ICustomTagLibrary[] getLibraries() {
        if (this.libs == null) {
            this.init();
        }
        return this.libs;
    }

    public CustomTagLibAttribute[] getComponentExtensions() {
        if (this.extensions == null) {
            this.init();
        }
        return this.extensions;
    }

    private void init() {
        HashSet<HTMLTagLibrary> libSet = new HashSet<HTMLTagLibrary>();
        HashSet<CustomTagLibAttribute> extensionSet = new HashSet<CustomTagLibAttribute>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.jst.web.kb.tagLib");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    block21: {
                        String elementName = elements[j].getName();
                        if ("tag-lib".equals(elementName)) {
                            String uri = elements[j].getAttribute("uri");
                            String location = elements[j].getAttribute("location");
                            String version = elements[j].getAttribute("version");
                            String name = elements[j].getAttribute("name");
                            Bundle sourcePlugin = Platform.getBundle((String)elements[j].getNamespaceIdentifier());
                            File schemaLocation = null;
                            try {
                                String pluginPath = FileLocator.resolve((URL)sourcePlugin.getEntry("/")).getPath();
                                if (uri == null || uri.length() == 0 || location == null || location.length() == 0) {
                                    WebKbPlugin.getDefault().logWarning("Incorrect org.jboss.tools.jst.web.kb.KbTagLib extension in " + pluginPath + " plugin. URI or location can't be empty.");
                                    break block21;
                                }
                                schemaLocation = new File(pluginPath, location);
                            }
                            catch (IOException e) {
                                WebKbPlugin.getDefault().logError(e);
                                break block21;
                            }
                            if (schemaLocation.isFile()) {
                                CustomTagLibrary lib = FACELETS_HTML_TAG_LIB_URI.equals(uri) ? new HTMLTagLibrary(schemaLocation, uri, version, name) : new CustomTagLibrary(schemaLocation, uri, version, name);
                                libSet.add((HTMLTagLibrary)lib);
                            } else {
                                WebKbPlugin.getDefault().logWarning("Can't load KB schema: " + schemaLocation);
                            }
                        } else if ("component-extension".equals(elementName)) {
                            String location = elements[j].getAttribute("location");
                            Bundle sourcePlugin = Platform.getBundle((String)elements[j].getNamespaceIdentifier());
                            File schemaLocation = null;
                            try {
                                String pluginPath = FileLocator.resolve((URL)sourcePlugin.getEntry("/")).getPath();
                                if (location == null || location.length() == 0) {
                                    WebKbPlugin.getDefault().logWarning("Incorrect org.jboss.tools.jst.web.kb.KbTagLib extension in " + pluginPath + " plugin. Location can't be empty.");
                                    break block21;
                                }
                                schemaLocation = new File(pluginPath, location);
                            }
                            catch (IOException e) {
                                WebKbPlugin.getDefault().logError(e);
                                break block21;
                            }
                            if (schemaLocation.isFile()) {
                                Document document = null;
                                try {
                                    DocumentBuilder builder = CustomTagLibrary.createDocumentBuilder(false);
                                    document = builder.parse(schemaLocation);
                                }
                                catch (SAXException e) {
                                    WebKbPlugin.getDefault().logError(e);
                                }
                                catch (IOException e) {
                                    WebKbPlugin.getDefault().logError(e);
                                }
                                catch (ParserConfigurationException e) {
                                    WebKbPlugin.getDefault().logError(e);
                                }
                                Element root = document.getDocumentElement();
                                CustomTagLibAttribute[] attributes = CustomTagLibrary.getAttributes(root);
                                int k = 0;
                                while (k < attributes.length) {
                                    extensionSet.add(attributes[k]);
                                    ++k;
                                }
                            } else {
                                WebKbPlugin.getDefault().logWarning("Can't load KB schema: " + schemaLocation);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.libs = libSet.toArray(new ICustomTagLibrary[0]);
        this.extensions = extensionSet.toArray(new CustomTagLibAttribute[0]);
    }
}

