/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.jboss.tools.jst.web.kb.internal.validation.ContextValidationHelper;
import org.jboss.tools.jst.web.kb.internal.validation.ValidationContext;
import org.jboss.tools.jst.web.kb.validation.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorManager
implements IValidatorJob {
    private static Set<IProject> validatingProjects = new HashSet<IProject>();

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        ContextValidationHelper validationHelper = (ContextValidationHelper)helper;
        IProject project = validationHelper.getProject();
        if (project == null) {
            return OK_STATUS;
        }
        IProject rootProject = validationHelper.getValidationContext().getRootProject();
        IStatus status = OK_STATUS;
        Set<IProject> set = validatingProjects;
        synchronized (set) {
            if (validatingProjects.contains(rootProject)) {
                return OK_STATUS;
            }
            validatingProjects.add(rootProject);
        }
        set = validatingProjects;
        synchronized (set) {
            ValidationContext validationContext = null;
            try {
                validationContext = new ValidationContext(project);
                validationHelper.setValidationContext(validationContext);
                List<IValidator> validators = validationHelper.getValidationContext().getValidators();
                Set<IFile> changedFiles = validationHelper.getChangedFiles();
                if (!changedFiles.isEmpty()) {
                    status = this.validate(validators, changedFiles, rootProject, validationHelper, reporter);
                } else if (!validationContext.getRegisteredFiles().isEmpty()) {
                    validationContext.clearAllResourceLinks();
                    status = this.validateAll(validators, rootProject, validationHelper, reporter);
                }
            }
            finally {
                if (validationContext != null) {
                    validationContext.clearRegisteredFiles();
                }
                validatingProjects.remove(rootProject);
            }
        }
        return status;
    }

    private IStatus validate(List<IValidator> validators, Set<IFile> changedFiles, IProject rootProject, ContextValidationHelper validationHelper, IReporter reporter) throws ValidationException {
        for (IValidator validator : validators) {
            validator.validate(changedFiles, rootProject, validationHelper, this, reporter);
        }
        return OK_STATUS;
    }

    private IStatus validateAll(List<IValidator> validators, IProject rootProject, ContextValidationHelper validationHelper, IReporter reporter) throws ValidationException {
        for (IValidator validator : validators) {
            validator.validateAll(rootProject, validationHelper, this, reporter);
        }
        return OK_STATUS;
    }

    public void cleanup(IReporter reporter) {
        reporter = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

