/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.validation.ContextValidationHelper;
import org.jboss.tools.jst.web.kb.internal.validation.ProblemMessage;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;
import org.jboss.tools.jst.web.kb.validation.IValidationErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidationErrorManager
implements IValidationErrorManager {
    protected IStatus OK_STATUS = new Status(0, "org.eclipse.wst.validation", 0, "OK", null);
    protected IValidator validationManager;
    protected ContextValidationHelper coreHelper;
    protected IReporter reporter;
    protected IProject rootProject;
    protected String markerId;
    protected IValidationContext validationContext;
    protected TextFileDocumentProvider documentProvider;

    public void init(IProject project, ContextValidationHelper validationHelper, IValidator manager, IReporter reporter) {
        this.setRootProject(project);
        this.setCoreHelper(validationHelper);
        this.setValidationManager(manager);
        this.setReporter(reporter);
        this.setValidationContext(validationHelper.getValidationContext());
        this.setMarkerId("markedKbResource");
    }

    public void setValidationManager(IValidator validationManager) {
        this.validationManager = validationManager;
    }

    public void setCoreHelper(ContextValidationHelper coreHelper) {
        this.coreHelper = coreHelper;
    }

    public void setReporter(IReporter reporter) {
        this.reporter = reporter;
    }

    public void setRootProject(IProject rootProject) {
        this.rootProject = rootProject;
    }

    public void setMarkerId(String markerId) {
        this.markerId = markerId;
    }

    public void setValidationContext(IValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, ITextSourceReference location, IResource target) {
        return this.addError(message, preferenceKey, messageArguments, location.getLength(), location.getStartPosition(), target);
    }

    @Override
    public IMarker addError(String message, String preferenceKey, ITextSourceReference location, IResource target) {
        return this.addError(message, preferenceKey, new String[0], location, target);
    }

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, IResource target) {
        return this.addError(message, preferenceKey, messageArguments, 0, 0, target);
    }

    private String getMarkerId() {
        return this.markerId;
    }

    protected abstract String getPreference(IProject var1, String var2);

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, int length, int offset, IResource target) {
        String preferenceValue = this.getPreference(target.getProject(), preferenceKey);
        boolean ignore = false;
        int messageSeverity = 1;
        if ("warning".equals(preferenceValue)) {
            messageSeverity = 2;
        } else if ("ignore".equals(preferenceValue)) {
            ignore = true;
        }
        if (ignore) {
            return null;
        }
        ProblemMessage problemMessage = new ProblemMessage(message, messageSeverity, messageArguments, target, this.getMarkerId());
        problemMessage.setLength(length);
        problemMessage.setOffset(offset);
        try {
            try {
                if (this.getDocumentProvider() != null) {
                    this.getDocumentProvider().connect((Object)target);
                    IDocument document = this.getDocumentProvider().getDocument((Object)target);
                    if (document != null) {
                        problemMessage.setLineNo(document.getLineOfOffset(offset) + 1);
                    }
                }
            }
            catch (BadLocationException e) {
                WebKbPlugin.getDefault().logError("Exception occurred during error line number calculation", e);
                if (this.getDocumentProvider() != null) {
                    this.getDocumentProvider().disconnect((Object)target);
                }
                return null;
            }
            catch (CoreException e) {
                block18: {
                    WebKbPlugin.getDefault().logError("Exception occurred during error line number calculation", e);
                    if (this.getDocumentProvider() == null) break block18;
                    this.getDocumentProvider().disconnect((Object)target);
                }
                return null;
            }
        }
        finally {
            if (this.getDocumentProvider() != null) {
                this.getDocumentProvider().disconnect((Object)target);
            }
        }
        int severity = problemMessage.getSeverity();
        try {
            return TaskListUtility.addTask((String)this.getMarkerOwner().getName().intern(), (IResource)target, (String)("" + problemMessage.getLineNumber()), (String)problemMessage.getText(), (String)problemMessage.getText(), (int)severity, null, (String)problemMessage.getGroupName(), (int)problemMessage.getOffset(), (int)problemMessage.getLength());
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
            return null;
        }
    }

    protected TextFileDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = this.coreHelper != null ? this.coreHelper.getDocumentProvider() : new TextFileDocumentProvider();
        }
        return this.documentProvider;
    }

    protected Class getMarkerOwner() {
        return this.getClass();
    }

    @Override
    public IMarker addError(String message, int severity, String[] messageArguments, int length, int offset, IResource target) {
        return ValidationErrorManager.addError(message, severity, messageArguments, length, offset, target, this.getDocumentProvider(), this.getMarkerId(), this.getMarkerOwner());
    }

    public static IMarker addError(String message, int severity, String[] messageArguments, int length, int offset, IResource target, TextFileDocumentProvider documentProvider, String markerId, Class markerOwner) {
        ProblemMessage problemMessage = new ProblemMessage(message, severity, messageArguments, target, markerId);
        problemMessage.setLength(length);
        problemMessage.setOffset(offset);
        try {
            try {
                if (documentProvider != null) {
                    documentProvider.connect((Object)target);
                    problemMessage.setLineNo(documentProvider.getDocument((Object)target).getLineOfOffset(offset) + 1);
                }
            }
            catch (BadLocationException e) {
                WebKbPlugin.getDefault().logError("Exception occurred during error line number calculation", e);
                documentProvider.disconnect((Object)target);
                return null;
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError("Exception occurred during error line number calculation", e);
                documentProvider.disconnect((Object)target);
                return null;
            }
        }
        finally {
            documentProvider.disconnect((Object)target);
        }
        try {
            return TaskListUtility.addTask((String)markerOwner.getName().intern(), (IResource)target, (String)("" + problemMessage.getLineNumber()), (String)problemMessage.getText(), (String)problemMessage.getText(), (int)severity, null, (String)problemMessage.getGroupName(), (int)problemMessage.getOffset(), (int)problemMessage.getLength());
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
            return null;
        }
    }

    @Override
    public void displaySubtask(String messageId) {
        this.displaySubtask(messageId, null);
    }

    @Override
    public void displaySubtask(String message, String[] messageArguments) {
        ProblemMessage problemMessage = new ProblemMessage(message, 2, messageArguments);
        this.reporter.displaySubtask(this.validationManager, (IMessage)problemMessage);
    }

    @Override
    public void removeMessagesFromResources(Set<IResource> resources) {
        for (IResource r : resources) {
            WorkbenchReporter.removeAllMessages((IResource)r, (String[])new String[]{this.getMarkerOwner().getName()}, null);
        }
    }

    @Override
    public void removeAllMessagesFromResource(IResource resource) {
        WorkbenchReporter.removeAllMessages((IResource)resource, (String[])new String[]{this.getMarkerOwner().getName()}, null);
    }
}

