/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.internal.validation.ELValidatorContext;
import org.jboss.tools.jst.web.kb.internal.validation.LinkCollection;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;
import org.jboss.tools.jst.web.kb.validation.IValidator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectValidationContext
implements IValidationContext {
    private LinkCollection coreLinks = new LinkCollection();
    private ELValidatorContext elLinks = new ELValidatorContext();
    private Set<IFile> removedFiles = new HashSet<IFile>();
    private Set<IFile> registeredResources = new HashSet<IFile>();
    private Set<String> oldVariableNamesForELValidation = new HashSet<String>();

    @Override
    public void addLinkedCoreResource(String variableName, IPath linkedResourcePath, boolean declaration) {
        this.coreLinks.addLinkedResource(variableName, linkedResourcePath, declaration);
    }

    @Override
    public void removeLinkedCoreResource(String name, IPath linkedResourcePath) {
        this.coreLinks.removeLinkedResource(name, linkedResourcePath);
    }

    @Override
    public void removeLinkedCoreResources(Set<IPath> resources) {
        this.coreLinks.removeLinkedResources(resources);
    }

    @Override
    public void removeLinkedCoreResource(IPath resource) {
        this.coreLinks.removeLinkedResource(resource);
    }

    @Override
    public Set<IPath> getCoreResourcesByVariableName(String variableName, boolean declaration) {
        return this.coreLinks.getResourcesByVariableName(variableName, declaration);
    }

    @Override
    public Set<String> getVariableNamesByCoreResource(IPath fullPath, boolean declaration) {
        return this.coreLinks.getVariableNamesByResource(fullPath, declaration);
    }

    @Override
    public void addUnnamedCoreResource(IPath fullPath) {
        this.coreLinks.addUnnamedResource(fullPath);
    }

    @Override
    public Set<IPath> getUnnamedCoreResources() {
        return this.coreLinks.getUnnamedResources();
    }

    @Override
    public void removeUnnamedCoreResource(IPath fullPath) {
        this.coreLinks.removeUnnamedResource(fullPath);
    }

    @Override
    public void addUnnamedElResource(IPath fullPath) {
        this.elLinks.addUnnamedResource(fullPath);
    }

    @Override
    public Set<IPath> getUnnamedElResources() {
        return this.elLinks.getUnnamedResources();
    }

    @Override
    public void removeUnnamedElResource(IPath fullPath) {
        this.elLinks.removeUnnamedResource(fullPath);
    }

    @Override
    public void addVariableNameForELValidation(String name) {
        this.oldVariableNamesForELValidation.add(name);
    }

    @Override
    public void removeLinkedEls(Set<IFile> resorces) {
        this.elLinks.removeLinkedEls(resorces);
    }

    @Override
    public Set<ELReference> getElsForValidation(Set<IFile> changedFiles, boolean onlyChangedVariables) {
        HashSet<ELReference> result = new HashSet<ELReference>();
        for (IResource iResource : changedFiles) {
            Set<ELReference> els;
            Set<String> newNames = this.getVariableNamesByCoreResource(iResource.getFullPath(), true);
            if (newNames != null) {
                for (String newName : newNames) {
                    if (onlyChangedVariables && this.oldVariableNamesForELValidation.contains(newName) || (els = this.elLinks.getElsByVariableName(newName)) == null) continue;
                    result.addAll(els);
                }
            }
            for (String oldName : this.oldVariableNamesForELValidation) {
                if (onlyChangedVariables && newNames != null && newNames.contains(oldName) || (els = this.elLinks.getElsByVariableName(oldName)) == null) continue;
                result.addAll(els);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        this.removedFiles.clear();
        Set<IFile> set = this.registeredResources;
        synchronized (set) {
            this.registeredResources.clear();
        }
        this.oldVariableNamesForELValidation.clear();
        this.coreLinks.clearAll();
        this.elLinks.clearAll();
    }

    @Override
    public void clearAllResourceLinks() {
        this.oldVariableNamesForELValidation.clear();
        this.coreLinks.clearAll();
        this.elLinks.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRegisteredFiles() {
        this.removedFiles.clear();
        Set<IFile> set = this.registeredResources;
        synchronized (set) {
            this.registeredResources.clear();
        }
    }

    @Override
    public void clearElResourceLinks() {
        this.oldVariableNamesForELValidation.clear();
        this.elLinks.clearAll();
    }

    @Override
    public void clearOldVariableNameForElValidation() {
        this.oldVariableNamesForELValidation.clear();
    }

    @Override
    public void addLinkedEl(String variableName, ELReference el) {
        this.elLinks.addLinkedEl(variableName, el);
    }

    @Override
    public void removeLinkedEl(String name, ELReference el) {
        this.elLinks.removeLinkedEl(name, el);
    }

    @Override
    public Set<ELReference> getElsByVariableName(String variableName) {
        return this.elLinks.getElsByVariableName(variableName);
    }

    @Override
    public void store(Element root) {
        Element validation = XMLUtilities.createElement((Element)root, (String)"validation");
        Element core = XMLUtilities.createElement((Element)validation, (String)"core");
        this.coreLinks.store(core);
        Element el = XMLUtilities.createElement((Element)validation, (String)"el");
        this.elLinks.store(el);
    }

    @Override
    public void load(Element root) {
        Element el;
        Element validation = XMLUtilities.getUniqueChild((Element)root, (String)"validation");
        if (validation == null) {
            return;
        }
        Element core = XMLUtilities.getUniqueChild((Element)validation, (String)"core");
        if (core != null) {
            this.coreLinks.load(core);
        }
        if ((el = XMLUtilities.getUniqueChild((Element)validation, (String)"el")) != null) {
            this.elLinks.load(el);
        }
    }

    @Override
    public Set<IFile> getRemovedFiles() {
        return this.removedFiles;
    }

    @Override
    public void addRemovedFile(IFile file) {
        this.removedFiles.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IFile> getRegisteredFiles() {
        HashSet<IFile> copy = new HashSet<IFile>();
        Set<IFile> set = this.registeredResources;
        synchronized (set) {
            copy.addAll(this.registeredResources);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFile(IFile file) {
        Set<IFile> set = this.registeredResources;
        synchronized (set) {
            this.registeredResources.add(file);
        }
    }

    @Override
    public IProject getRootProject() {
        return null;
    }

    @Override
    public List<IValidator> getValidators() {
        return null;
    }
}

