/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.KbMessages;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkCollection {
    protected Map<String, Set<IPath>> resourcesByVariableName = new HashMap<String, Set<IPath>>();
    protected Map<IPath, Set<String>> variableNamesByResource = new HashMap<IPath, Set<String>>();
    protected Map<String, Set<IPath>> resourcesByDeclaringVariableName = new HashMap<String, Set<IPath>>();
    protected Map<IPath, Set<String>> declaringVariableNamesByResource = new HashMap<IPath, Set<String>>();
    protected Set<IPath> unnamedResources = new HashSet<IPath>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinkedResource(String variableName, IPath linkedResourcePath, boolean declaration) {
        if (linkedResourcePath == null) {
            throw new IllegalArgumentException(KbMessages.VALIDATION_CONTEXT_LINKED_RESOURCE_PATH_MUST_NOT_BE_NULL);
        }
        if (variableName == null) {
            throw new IllegalArgumentException(KbMessages.VALIDATION_CONTEXT_VARIABLE_NAME_MUST_NOT_BE_NULL);
        }
        LinkCollection linkCollection = this;
        synchronized (linkCollection) {
            Set<IPath> linkedResources = this.resourcesByVariableName.get(variableName);
            if (linkedResources == null) {
                linkedResources = new HashSet<IPath>();
                this.resourcesByVariableName.put(variableName, linkedResources);
            }
            linkedResources.add(linkedResourcePath);
        }
        Set<String> variableNames = this.variableNamesByResource.get(linkedResourcePath);
        if (variableNames == null) {
            variableNames = new HashSet<String>();
            this.variableNamesByResource.put(linkedResourcePath, variableNames);
        }
        variableNames.add(variableName);
        if (declaration) {
            LinkCollection linkCollection2 = this;
            synchronized (linkCollection2) {
                Set<IPath> linkedResources = this.resourcesByDeclaringVariableName.get(variableName);
                if (linkedResources == null) {
                    linkedResources = new HashSet<IPath>();
                    this.resourcesByDeclaringVariableName.put(variableName, linkedResources);
                }
                linkedResources.add(linkedResourcePath);
            }
            variableNames = this.declaringVariableNamesByResource.get(linkedResourcePath);
            if (variableNames == null) {
                variableNames = new HashSet<String>();
                this.declaringVariableNamesByResource.put(linkedResourcePath, variableNames);
            }
            variableNames.add(variableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinkedResource(String name, IPath linkedResourcePath) {
        LinkCollection linkCollection = this;
        synchronized (linkCollection) {
            Set<IPath> linkedResources = this.resourcesByVariableName.get(name);
            if (linkedResources != null) {
                linkedResources.remove(linkedResourcePath);
            }
            if (linkedResources.isEmpty()) {
                this.resourcesByVariableName.remove(name);
            }
        }
        Set<String> variableNames = this.variableNamesByResource.get(linkedResourcePath);
        if (variableNames != null) {
            variableNames.remove(name);
        }
        if (variableNames.isEmpty()) {
            this.variableNamesByResource.remove(linkedResourcePath);
        }
        LinkCollection linkCollection2 = this;
        synchronized (linkCollection2) {
            Set<IPath> linkedResources = this.resourcesByDeclaringVariableName.get(name);
            if (linkedResources != null) {
                linkedResources.remove(linkedResourcePath);
            }
            if (linkedResources.isEmpty()) {
                this.resourcesByDeclaringVariableName.remove(name);
            }
        }
        variableNames = this.declaringVariableNamesByResource.get(linkedResourcePath);
        if (variableNames != null) {
            variableNames.remove(name);
        }
        if (variableNames.isEmpty()) {
            this.declaringVariableNamesByResource.remove(linkedResourcePath);
        }
    }

    public void removeLinkedResources(Set<IPath> resources) {
        for (IPath resource : resources) {
            this.removeLinkedResource(resource);
        }
    }

    public synchronized void removeLinkedResource(IPath resource) {
        Set<IPath> linkedResources;
        Set<String> resourceNames = this.variableNamesByResource.get(resource);
        if (resourceNames != null) {
            for (String name : resourceNames) {
                linkedResources = this.resourcesByVariableName.get(name);
                if (linkedResources == null) continue;
                linkedResources.remove(resource);
                if (!linkedResources.isEmpty()) continue;
                this.resourcesByVariableName.remove(name);
            }
        }
        this.variableNamesByResource.remove(resource);
        resourceNames = this.declaringVariableNamesByResource.get(resource);
        if (resourceNames != null) {
            for (String name : resourceNames) {
                linkedResources = this.resourcesByDeclaringVariableName.get(name);
                if (linkedResources == null) continue;
                linkedResources.remove(resource);
                if (!linkedResources.isEmpty()) continue;
                this.resourcesByDeclaringVariableName.remove(name);
            }
        }
        this.declaringVariableNamesByResource.remove(resource);
    }

    public Set<IPath> getResourcesByVariableName(String variableName, boolean declaration) {
        return declaration ? this.resourcesByDeclaringVariableName.get(variableName) : this.resourcesByVariableName.get(variableName);
    }

    public synchronized Set<String> getVariableNamesByResource(IPath fullPath, boolean declaration) {
        return declaration ? this.declaringVariableNamesByResource.get(fullPath) : this.variableNamesByResource.get(fullPath);
    }

    public void addUnnamedResource(IPath fullPath) {
        this.unnamedResources.add(fullPath);
    }

    public Set<IPath> getUnnamedResources() {
        return this.unnamedResources;
    }

    public void removeUnnamedResource(IPath fullPath) {
        this.unnamedResources.remove(fullPath);
    }

    public synchronized void clearAll() {
        this.resourcesByVariableName.clear();
        this.variableNamesByResource.clear();
        this.declaringVariableNamesByResource.clear();
        this.resourcesByDeclaringVariableName.clear();
        this.unnamedResources.clear();
    }

    public synchronized void store(Element root) {
        Set<String> variables = this.resourcesByVariableName.keySet();
        for (String name : variables) {
            Set<IPath> paths = this.resourcesByVariableName.get(name);
            if (paths == null) continue;
            for (IPath path : paths) {
                Element linkedResource = XMLUtilities.createElement((Element)root, (String)"linked-resource");
                linkedResource.setAttribute("name", name);
                linkedResource.setAttribute("path", path.toString());
                if (!this.checkDeclaration(path, name)) continue;
                linkedResource.setAttribute("declaration", "true");
            }
        }
        for (IPath unnamedPath : this.unnamedResources) {
            Element unnamedPathElement = XMLUtilities.createElement((Element)root, (String)"unnamed-path");
            unnamedPathElement.setAttribute("path", unnamedPath.toString());
        }
    }

    private boolean checkDeclaration(IPath resource, String variableName) {
        Set<IPath> paths = this.resourcesByDeclaringVariableName.get(variableName);
        if (paths != null) {
            for (IPath path : paths) {
                if (!path.equals((Object)resource)) continue;
                return true;
            }
        }
        return false;
    }

    public void load(Element root) {
        Element[] unnamedPathElement;
        String path;
        if (root == null) {
            return;
        }
        Element[] linkedResources = XMLUtilities.getChildren((Element)root, (String)"linked-resource");
        if (linkedResources != null) {
            int i = 0;
            while (i < linkedResources.length) {
                String name = linkedResources[i].getAttribute("name");
                if (name != null && name.trim().length() != 0 && (path = linkedResources[i].getAttribute("path")) != null && path.trim().length() != 0) {
                    String declaration = linkedResources[i].getAttribute("declaration");
                    boolean declarationFlag = "true".equals(declaration);
                    Path pathObject = new Path(path);
                    this.addLinkedResource(name, (IPath)pathObject, declarationFlag);
                }
                ++i;
            }
        }
        if ((unnamedPathElement = XMLUtilities.getChildren((Element)root, (String)"unnamed-path")) != null) {
            int i = 0;
            while (i < unnamedPathElement.length) {
                path = unnamedPathElement[i].getAttribute("path");
                Path pathObject = new Path(path);
                this.addUnnamedResource((IPath)pathObject);
                ++i;
            }
        }
    }
}

