/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.el.KbELReference;
import org.jboss.tools.jst.web.kb.internal.validation.LinkCollection;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELValidatorContext
extends LinkCollection {
    private Map<String, Set<ELReference>> elsByVariableName = new HashMap<String, Set<ELReference>>();
    private Map<ELReference, Set<String>> variableNamesByEl = new HashMap<ELReference, Set<String>>();
    private Map<IPath, Set<ELReference>> elsByResource = new HashMap<IPath, Set<ELReference>>();

    public synchronized void addLinkedEl(String variableName, ELReference el) {
        Set<ELReference> linkedEls = this.elsByVariableName.get(variableName);
        if (linkedEls == null) {
            linkedEls = new HashSet<ELReference>();
            this.elsByVariableName.put(variableName, linkedEls);
        }
        linkedEls.add(el);
        Set<String> variableNames = this.variableNamesByEl.get(el);
        if (variableNames == null) {
            variableNames = new HashSet<String>();
            this.variableNamesByEl.put(el, variableNames);
        }
        variableNames.add(variableName);
        Set<ELReference> els = this.elsByResource.get(el.getPath());
        if (els == null) {
            els = new HashSet<ELReference>();
            this.elsByResource.put(el.getPath(), els);
        }
        els.add(el);
    }

    public synchronized void removeLinkedEls(Set<IFile> resorces) {
        for (IFile file : resorces) {
            this.removeLinkedEls(file);
        }
    }

    public synchronized void removeLinkedEls(IFile resource) {
        Set<ELReference> els = this.elsByResource.get(resource.getFullPath());
        if (els != null) {
            this.elsByResource.remove(resource.getFullPath());
            for (ELReference el : els) {
                Set<String> names = this.variableNamesByEl.get(el);
                if (names == null) continue;
                String[] nameStrins = names.toArray(new String[0]);
                int i = 0;
                while (i < nameStrins.length) {
                    this.removeLinkedEl(nameStrins[i], el);
                    ++i;
                }
            }
        }
    }

    public synchronized void removeLinkedEl(String name, ELReference el) {
        Set<String> variableNames;
        Set<ELReference> linkedEls = this.elsByVariableName.get(name);
        if (linkedEls != null) {
            linkedEls.remove(el);
        }
        if (linkedEls.isEmpty()) {
            this.elsByVariableName.remove(name);
        }
        if ((variableNames = this.variableNamesByEl.get(el)) != null) {
            variableNames.remove(name);
        }
        if (variableNames.isEmpty()) {
            this.variableNamesByEl.remove(el);
        }
    }

    public synchronized Set<ELReference> getElsByVariableName(String variableName) {
        return this.elsByVariableName.get(variableName);
    }

    public synchronized Set<ELReference> getElsByVariableNames(Set<String> names) {
        HashSet<ELReference> result = new HashSet<ELReference>();
        for (String name : names) {
            Set<ELReference> els = this.getElsByVariableName(name);
            if (els == null) continue;
            result.addAll(els);
        }
        return result;
    }

    @Override
    public synchronized void clearAll() {
        super.clearAll();
        this.elsByVariableName.clear();
        this.variableNamesByEl.clear();
        this.elsByResource.clear();
    }

    @Override
    public synchronized void store(Element root) {
        super.store(root);
        Set<String> variables = this.elsByVariableName.keySet();
        for (String name : variables) {
            Set<ELReference> els = this.elsByVariableName.get(name);
            if (els == null) continue;
            for (ELReference el : els) {
                Element linkedEl = XMLUtilities.createElement((Element)root, (String)"linked-el");
                linkedEl.setAttribute("name", name);
                el.store(linkedEl);
            }
        }
    }

    @Override
    public synchronized void load(Element root) {
        super.load(root);
        if (root == null) {
            return;
        }
        Element[] linkedEls = XMLUtilities.getChildren((Element)root, (String)"linked-el");
        if (linkedEls != null) {
            int i = 0;
            while (i < linkedEls.length) {
                String name = linkedEls[i].getAttribute("name");
                if (name != null && name.trim().length() != 0) {
                    KbELReference el = new KbELReference();
                    el.load(linkedEls[i]);
                    el.setNeedToInitMarkers(true);
                    this.addLinkedEl(name, el);
                }
                ++i;
            }
        }
    }
}

