/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.jboss.tools.jst.web.kb.internal.validation.ValidationContext;
import org.jboss.tools.jst.web.kb.validation.IValidatingProjectSet;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;
import org.jboss.tools.jst.web.kb.validation.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextValidationHelper
extends WorkbenchContext {
    protected IValidationContext validationContext;
    protected TextFileDocumentProvider documentProvider = new TextFileDocumentProvider();
    protected Map<IProject, IValidationContext> contexts;

    public void initialize() {
        this.validationContext = null;
        this.contexts = new HashMap<IProject, IValidationContext>();
    }

    public void registerResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            IValidationContext context = this.contexts.get(file.getProject());
            if (context == null) {
                context = new ValidationContext(file.getProject());
                this.contexts.put(file.getProject(), context);
            }
            if (!file.exists()) {
                context.addRemovedFile(file);
            } else {
                context.registerFile(file);
            }
        }
    }

    public Set<IFile> getChangedFiles() {
        List<IValidator> validators = this.getValidationContext().getValidators();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IValidator validator : validators) {
            IValidatingProjectSet set = validator.getValidatingProjects(this.getProject());
            projects.addAll(set.getAllProjests());
        }
        HashSet<IFile> result = new HashSet<IFile>();
        String[] uris = this.getURIs();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < uris.length) {
            IFile currentFile = root.getFile((IPath)new Path(uris[i]));
            if (projects.contains(currentFile.getProject())) {
                result.add(currentFile);
            }
            ++i;
        }
        Set<IFile> removedFiles = this.getValidationContext().getRemovedFiles();
        for (IFile file : removedFiles) {
            if (!projects.contains(file.getProject())) continue;
            result.add(file);
        }
        return result;
    }

    public Set<IFile> getProjectSetRegisteredFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        List<IValidator> validators = this.getValidationContext().getValidators();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IValidator validator : validators) {
            IValidatingProjectSet set = validator.getValidatingProjects(this.getProject());
            projects.addAll(set.getAllProjests());
        }
        Set<IFile> files = this.validationContext.getRegisteredFiles();
        for (IFile file : files) {
            if (!projects.contains(file.getProject())) continue;
            result.add(file);
        }
        return result;
    }

    public IValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new ValidationContext(this.getProject());
        }
        return this.validationContext;
    }

    public void setValidationContext(IValidationContext context) {
        this.validationContext = context;
    }

    public TextFileDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }
}

