/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractComponent;
import org.jboss.tools.jst.web.kb.taglib.Facet;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigComponent
extends AbstractComponent {
    Map<String, Facet> facets = new HashMap<String, Facet>();
    Facet[] facetArray = EMPTY_FACET_SET;
    public static final Facet[] EMPTY_FACET_SET = new Facet[0];

    @Override
    public Facet getFacet(String name) {
        return this.facets.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Facet[] getFacets() {
        if (this.facetArray == null) {
            Map<String, Facet> map = this.facets;
            synchronized (map) {
                this.facetArray = this.facets.isEmpty() ? EMPTY_FACET_SET : this.facets.values().toArray(new Facet[0]);
            }
        }
        return this.facetArray;
    }

    @Override
    public Facet[] getFacets(String nameTemplate) {
        Facet[] fs = this.getFacets();
        if (fs.length == 0) {
            return EMPTY_FACET_SET;
        }
        ArrayList<Facet> result = new ArrayList<Facet>();
        Facet[] facetArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            Facet f = facetArray[n2];
            String name = f.getName();
            boolean match = name.startsWith(nameTemplate);
            if (match) {
                result.add(f);
            }
            ++n2;
        }
        return result.isEmpty() ? EMPTY_FACET_SET : result.toArray(new Facet[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFacet(Facet f) {
        this.adopt(f);
        Map<String, Facet> map = this.facets;
        synchronized (map) {
            this.facets.put(f.getName(), f);
            this.facetArray = null;
        }
    }

    @Override
    public FacesConfigComponent clone() throws CloneNotSupportedException {
        FacesConfigComponent copy = new FacesConfigComponent();
        copy.facets = new HashMap<String, Facet>();
        Facet[] facetArray = this.getFacets();
        int n = facetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Facet f = facetArray[n2];
            copy.addFacet(f.clone());
            ++n2;
        }
        return copy;
    }

    @Override
    public String getXMLClass() {
        return "faces-config";
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        FacesConfigComponent c = (FacesConfigComponent)s;
        Change children = new Change((Object)this, null, null, null);
        this.mergeFacets(c, children);
        changes = Change.addChange(changes, (Change)children);
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFacets(FacesConfigComponent c, Change children) {
        Facet f;
        HashMap<Object, Facet> facetMap = new HashMap<Object, Facet>();
        Object object = this.getFacets();
        int n = ((Facet[])object).length;
        int n2 = 0;
        while (n2 < n) {
            f = object[n2];
            facetMap.put(f.getId(), f);
            ++n2;
        }
        object = c.getFacets();
        n = ((Facet[])object).length;
        n2 = 0;
        while (n2 < n) {
            f = object[n2];
            Facet loaded = f;
            Facet current = (Facet)facetMap.get(loaded.getId());
            if (current == null) {
                this.addFacet(loaded);
                Change change = new Change((Object)this, null, null, (Object)loaded);
                children.addChildren(Change.addChange(null, (Change)change));
            } else {
                List<Change> rc = current.merge(loaded);
                if (rc != null) {
                    children.addChildren(rc);
                }
            }
            ++n2;
        }
        Iterator iterator = facetMap.values().iterator();
        while (iterator.hasNext()) {
            Facet removed = f = (Facet)iterator.next();
            object = this.facets;
            synchronized (object) {
                if (this.facets.get(removed.getName()) != removed) {
                    continue;
                }
                this.facets.remove(removed.getName());
                this.facetArray = null;
            }
            Change change = new Change((Object)this, null, (Object)removed, null);
            children.addChildren(Change.addChange(null, (Change)change));
        }
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        Facet[] facetArray = this.getFacets();
        int n = facetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Facet f = facetArray[n2];
            f.toXML(element, context);
            ++n2;
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        Element[] cs;
        super.loadXML(element, context);
        Element[] elementArray = cs = XMLUtilities.getChildren((Element)element, (String)"facet");
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Element e = elementArray[n2];
            Facet f = new Facet();
            f.loadXML(e, context);
            this.addFacet(f);
            ++n2;
        }
    }
}

