/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalTypeFactory;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomComponentExtension;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibComponent;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CustomTagLibrary
extends AbstractTagLib
implements ICustomTagLibrary {
    protected static final String DEFAULT_PREFIX = "defaultPrefix";
    public static final String TAG_LIB = "tag-lib";
    protected static final String COMPONENT = "component";
    protected static final String CLOSE_TAG = "closeTag";
    protected static final String TRUE = "true";
    protected static final String NAME = "name";
    protected static final String ATTRIBUTE = "attribute";
    protected static final String REQUIRED = "required";
    protected static final String PROPOSAL = "proposal";
    protected static final String TYPE = "type";
    protected static final String ENUMERATION = "enumeration";
    protected static final String PARAM = "param";
    protected static final String VALUE = "value";
    public static final String COMPONET_EXTENSION = "component-extension";
    protected static final String DEFAULT_VALUE = "defaultValue";
    protected static final String EXTENDED = "extended";
    protected static final String DESCRIPTION = "description";
    protected static final String IGNORE_CASE = "ignoreCase";
    protected String name;
    protected String defaultPrefix;

    public CustomTagLibrary(File file, String uri, String version, String name) {
        this.setURI(uri);
        this.setVersion(version);
        this.name = name;
        Document document = null;
        try {
            DocumentBuilder builder = CustomTagLibrary.createDocumentBuilder(false);
            document = builder.parse(file);
        }
        catch (SAXException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        catch (IOException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        catch (ParserConfigurationException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        Element tagLib = document.getDocumentElement();
        this.defaultPrefix = tagLib.getAttribute(DEFAULT_PREFIX);
        this.ignoreCase = TRUE.equals(tagLib.getAttribute(IGNORE_CASE));
        NodeList children = tagLib.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                if (child.getNodeName().equals(COMPONENT)) {
                    CustomTagLibComponent component = this.parseComponent((Element)child);
                    component.setIgnoreCase(this.ignoreCase);
                    this.addComponent(component);
                } else if (child.getNodeName().equals(COMPONET_EXTENSION)) {
                    if (this.componentExtension == null) {
                        this.componentExtension = new CustomComponentExtension();
                        this.addComponent(this.componentExtension);
                        this.componentExtension.setParentTagLib(this);
                    }
                    this.componentExtension.addAttributes(CustomTagLibrary.getAttributes((Element)child, this.ignoreCase));
                }
            }
            ++i;
        }
    }

    protected CustomTagLibComponent parseComponent(Element component) {
        String name = component.getAttribute(NAME);
        boolean closeTag = TRUE.equalsIgnoreCase(component.getAttribute(CLOSE_TAG));
        String description = CustomTagLibrary.getDescription(component);
        String extendedStr = component.getAttribute(EXTENDED);
        Boolean extended = extendedStr == null || extendedStr.length() == 0 || TRUE.equals(extendedStr);
        CustomTagLibComponent newComponent = this.createComponent();
        newComponent.setName(name);
        newComponent.setCanHaveBody(!closeTag);
        newComponent.setDescription(description);
        newComponent.setExtended(extended);
        newComponent.setParentTagLib(this);
        CustomTagLibAttribute[] attributes = CustomTagLibrary.getAttributes(component, this.ignoreCase);
        int i = 0;
        while (i < attributes.length) {
            newComponent.addAttribute(attributes[i]);
            attributes[i].setParentComponent(newComponent);
            ++i;
        }
        return newComponent;
    }

    protected CustomTagLibComponent createComponent() {
        return new CustomTagLibComponent();
    }

    public static CustomTagLibAttribute[] getAttributes(Element component) {
        return CustomTagLibrary.getAttributes(component, false);
    }

    public static CustomTagLibAttribute[] getAttributes(Element component, boolean ignoreCase) {
        HashSet<CustomTagLibAttribute> newAttributes = new HashSet<CustomTagLibAttribute>();
        NodeList children = component.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && child.getNodeName().equals(ATTRIBUTE)) {
                Element attribute = (Element)child;
                String attributeName = attribute.getAttribute(NAME);
                boolean required = TRUE.equalsIgnoreCase(attribute.getAttribute(REQUIRED));
                CustomTagLibAttribute newAttribute = new CustomTagLibAttribute();
                newAttribute.setIgnoreCase(ignoreCase);
                newAttribute.setName(attributeName);
                newAttribute.setRequired(required);
                String atrDescription = CustomTagLibrary.getDescription(attribute);
                newAttribute.setDescription(atrDescription);
                String extendedAtrStr = attribute.getAttribute(EXTENDED);
                Boolean extendedAtr = extendedAtrStr == null || extendedAtrStr.length() == 0 || TRUE.equals(extendedAtrStr);
                newAttribute.setExtended(extendedAtr);
                String defaultValue = attribute.getAttribute(DEFAULT_VALUE);
                newAttribute.setDefaultValue(defaultValue);
                newAttributes.add(newAttribute);
                ArrayList<CustomProposalType> newProposals = new ArrayList<CustomProposalType>();
                NodeList proposals = attribute.getElementsByTagName(PROPOSAL);
                int j = 0;
                while (j < proposals.getLength()) {
                    Element proposal = (Element)proposals.item(j);
                    String type = proposal.getAttribute(TYPE);
                    CustomProposalType newProposal = CustomProposalTypeFactory.getInstance().createProposalType(type);
                    if (newProposal != null) {
                        newProposal.setType(type);
                        newProposals.add(newProposal);
                        ArrayList<CustomProposalType.Param> newParams = new ArrayList<CustomProposalType.Param>();
                        NodeList params = proposal.getElementsByTagName(PARAM);
                        int c = 0;
                        while (c < params.getLength()) {
                            Element param = (Element)params.item(c);
                            String paramName = param.getAttribute(NAME);
                            String paramValue = param.getAttribute(VALUE);
                            CustomProposalType.Param newParam = new CustomProposalType.Param();
                            if (paramName != null && paramName.length() > 0) {
                                newParam.setName(paramName);
                            }
                            newParam.setValue(paramValue);
                            newParams.add(newParam);
                            ++c;
                        }
                        newProposal.setParams(newParams.toArray(new CustomProposalType.Param[0]));
                    }
                    ++j;
                }
                newAttribute.setProposals(newProposals.toArray(new CustomProposalType[0]));
            }
            ++i;
        }
        return newAttributes.toArray(new CustomTagLibAttribute[0]);
    }

    public static String getDescription(Element element) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element && DESCRIPTION.equals(node.getNodeName())) {
                return CustomTagLibrary.getElementBody((Element)node);
            }
            ++i;
        }
        return null;
    }

    public static String getElementBody(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            short nodeType = n.getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                sb.append(((CharacterData)n).getData());
            }
            ++i;
        }
        return sb.toString();
    }

    public static DocumentBuilder createDocumentBuilder(boolean validate) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(validate);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (!validate) {
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.toLowerCase().endsWith(".dtd")) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    return null;
                }
            });
        }
        return documentBuilder;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public CustomComponentExtension getComponentExtension() {
        return this.componentExtension;
    }
}

