/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.JSF2ResourcesScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;

public class LibraryScanner
implements IFileScanner {
    IPath sourcePath = null;

    public boolean isRelevant(IFile f) {
        return EclipseResourceUtil.isJar((String)f.getName());
    }

    public boolean isLikelyComponentSource(IFile f) {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return false;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (o == null) {
            return false;
        }
        if (!o.getModelEntity().getName().equals("FileSystemJar")) {
            ((FileSystemsImpl)o.getModel().getByPath("FileSystems")).updateOverlapped();
            o = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (o == null || !o.getModelEntity().getName().equals("FileSystemJar")) {
                return false;
            }
        }
        return this.isLikelyComponentSource(o);
    }

    public LoadedDeclarations parse(IFile f, IKbProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return null;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (o == null) {
            return null;
        }
        if (!o.getModelEntity().getName().equals("FileSystemJar")) {
            ((FileSystemsImpl)o.getModel().getByPath("FileSystems")).updateOverlapped();
            o = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (o == null || !o.getModelEntity().getName().equals("FileSystemJar")) {
                return null;
            }
        }
        return this.parse(o, f.getFullPath(), sp);
    }

    public boolean isLikelyComponentSource(XModelObject o) {
        if (o == null) {
            return false;
        }
        return o.getChildByPath("META-INF") != null;
    }

    public LoadedDeclarations parse(XModelObject o, IPath path, IKbProject sp) throws ScannerException {
        if (o == null) {
            return null;
        }
        this.sourcePath = path;
        XModelObject metaInf = o.getChildByPath("META-INF");
        if (metaInf == null) {
            return null;
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        if (metaInf != null) {
            XModelObject[] tlds;
            XModelObject[] xModelObjectArray = tlds = metaInf.getChildren();
            int n = tlds.length;
            int n2 = 0;
            while (n2 < n) {
                IFileScanner s;
                LoadedDeclarations ds1;
                XModelObject tld = xModelObjectArray[n2];
                if ((LibraryScanner.isFaceletTaglibFile(tld) || LibraryScanner.isTLDFile(tld) || LibraryScanner.isFacesConfigFile(tld)) && (ds1 = ((XMLScanner)(s = new XMLScanner())).parse(tld, path, sp)) != null) {
                    ds.add(ds1);
                }
                if (tld.getFileType() == 2 && tld.getAttributeValue("name").equals("resources") && (ds1 = ((JSF2ResourcesScanner)(s = new JSF2ResourcesScanner())).parse(tld, path, sp)) != null) {
                    ds.add(ds1);
                }
                ++n2;
            }
        }
        XModelObject[] ps = o.getChildren();
        int i = 0;
        while (i < ps.length) {
            LoadedDeclarations ds1;
            if (ps[i] != metaInf && ps[i].getFileType() == 2 && (ds1 = this.parseInPackages(ps[i], path, sp)) != null) {
                ds.add(ds1);
            }
            ++i;
        }
        return ds;
    }

    public LoadedDeclarations parseInPackages(XModelObject o, IPath path, IKbProject sp) throws ScannerException {
        XModelObject[] tlds;
        LoadedDeclarations ds = new LoadedDeclarations();
        XModelObject[] xModelObjectArray = tlds = o.getChildren();
        int n = tlds.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject tld = xModelObjectArray[n2];
            if (LibraryScanner.isFaceletTaglibFile(tld)) {
                XMLScanner s = new XMLScanner();
                LoadedDeclarations ds1 = s.parse(tld, path, sp);
                ds = this.add(ds, ds1);
                if (ds1 != null && !ds1.isEmpty()) {
                    System.out.println(String.valueOf(tld.getPath()) + ":" + ds1.getLibraries().get(0).getURI());
                }
            } else if (tld.getFileType() == 2) {
                LoadedDeclarations ds1 = this.parseInPackages(tld, path, sp);
                ds = this.add(ds, ds1);
            }
            ++n2;
        }
        return ds;
    }

    private LoadedDeclarations add(LoadedDeclarations total, LoadedDeclarations addition) {
        if (addition == null || addition.isEmpty()) {
            return total;
        }
        if (total == null) {
            total = new LoadedDeclarations();
        }
        total.add(addition);
        return total;
    }

    public static boolean isTLDFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith("FileTLD");
    }

    public static boolean isFaceletTaglibFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith("FileFaceletTaglib");
    }

    public static boolean isFacesConfigFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith("FacesConfig");
    }

    public static boolean isCompositeComponentFile(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        return entity.startsWith(JSF2ResourcesScanner.ENT_COMPOSITE_COMPONENT);
    }
}

