/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeTagLibrary;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;

public class JSF2ResourcesScanner
implements IFileScanner {
    public static String ATTR_SHORT_DESCRIPTION = "shortDescription";
    public static String URI_PREFIX = "http://java.sun.com/jsf/composite";
    public static String ENT_COMPOSITE_COMPONENT = "FileJSF2Component";

    public boolean isLikelyComponentSource(IFile f) {
        if (!f.isSynchronized(0) || !f.exists()) {
            return false;
        }
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return false;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (o == null) {
            return false;
        }
        if (LibraryScanner.isCompositeComponentFile(o)) {
            IContainer c = f.getParent();
            while (c != null && c instanceof IFolder) {
                if ("resources".equals(c.getName())) {
                    return true;
                }
                c = c.getParent();
            }
        }
        return false;
    }

    public boolean isRelevant(IFile resource) {
        return false;
    }

    public LoadedDeclarations parse(IFile f, IKbProject sp) throws ScannerException {
        return null;
    }

    public LoadedDeclarations parse(IFolder f, IKbProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return null;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        return this.parse(o, f.getFullPath(), sp);
    }

    public LoadedDeclarations parse(XModelObject o, IPath source, IKbProject sp) {
        if (o == null) {
            return null;
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        this.processFolder(o, ds, source, URI_PREFIX);
        return ds;
    }

    void processFolder(XModelObject o, LoadedDeclarations ds, IPath source, String uriPrefix) {
        XModelObject[] cs;
        CompositeTagLibrary library = null;
        XModelObject[] xModelObjectArray = cs = o.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            String entity;
            XModelObject c = xModelObjectArray[n2];
            if (c.getFileType() == 2) {
                String n3 = c.getAttributeValue("name");
                this.processFolder(c, ds, source, String.valueOf(uriPrefix) + "/" + n3);
            }
            if (ENT_COMPOSITE_COMPONENT.equals(entity = c.getModelEntity().getName())) {
                if (library == null) {
                    library = new CompositeTagLibrary();
                    library.setId(o);
                    library.setURI(this.createValueInfo(uriPrefix));
                    ds.getLibraries().add(library);
                }
                CompositeComponent component = new CompositeComponent();
                component.setId(c);
                IResource r = (IResource)c.getAdapter(IResource.class);
                if (r instanceof IFile) {
                    component.setSourcePath(r.getFullPath());
                }
                component.setName(this.createValueInfo(c.getAttributeValue("name")));
                library.addComponent(component);
                XModelObject is = c.getChildByPath("Interface");
                if (is != null) {
                    XModelObject[] as;
                    XModelObject[] xModelObjectArray2 = as = is.getChildren();
                    int n4 = as.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        XModelObject a = xModelObjectArray2[n5];
                        CompositeAttribute attr = new CompositeAttribute();
                        attr.setId(a);
                        attr.setName((IValueInfo)new XMLValueInfo(a, "name"));
                        attr.setDescription((IValueInfo)new XMLValueInfo(a, ATTR_SHORT_DESCRIPTION));
                        attr.setRequired((IValueInfo)new XMLValueInfo(a, "required"));
                        component.addAttribute(attr);
                        ++n5;
                    }
                }
            }
            ++n2;
        }
    }

    private IValueInfo createValueInfo(String value) {
        ValueInfo v = new ValueInfo();
        v.setValue(value);
        return v;
    }
}

