/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.proposal;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDProposalType
extends CustomProposalType {
    private static final String IMAGE_NAME = "EnumerationProposal.gif";
    private static Image ICON;
    static String ID;
    static String QUOTE_1;
    static String QUOTE_2;
    Set<String> idList = new TreeSet<String>();

    static {
        ID = "id";
        QUOTE_1 = "'";
        QUOTE_2 = "\"";
    }

    protected void init(IPageContext context) {
        this.idList.clear();
        IDocument document = context.getDocument();
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            if (sModel != null) {
                IDOMDocument sd;
                IDOMDocument iDOMDocument = sd = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
                if (sd != null) {
                    Element root = sd.getDocumentElement();
                    this.collectIDs(root);
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    private void collectIDs(Element element) {
        String id = element.getAttribute(ID);
        if (id != null && id.length() > 0) {
            this.idList.add(id);
        }
        NodeList cs = element.getChildNodes();
        int i = 0;
        while (i < cs.getLength()) {
            Node n = cs.item(i);
            if (n.getNodeType() == 1) {
                this.collectIDs((Element)n);
            }
            ++i;
        }
    }

    public TextProposal[] getProposals(KbQuery query) {
        String v = query.getValue();
        int offset = v.length();
        int b = v.lastIndexOf(44);
        b = b < 0 ? 0 : ++b;
        String tail = v.substring(offset);
        int e = tail.indexOf(44);
        e = e < 0 ? v.length() : (e += offset);
        String prefix = v.substring(b).trim();
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        for (String text : this.idList) {
            if (!text.startsWith(prefix)) continue;
            TextProposal proposal = new TextProposal();
            proposal.setLabel(text);
            proposal.setReplacementString(text);
            proposal.setPosition(b + text.length());
            proposal.setStart(b);
            proposal.setEnd(e);
            if (ICON == null) {
                ICON = ImageDescriptor.createFromFile(WebKbPlugin.class, (String)IMAGE_NAME).createImage();
            }
            proposal.setImage(ICON);
            proposals.add(proposal);
        }
        return proposals.toArray(new TextProposal[0]);
    }
}

