/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.internal.LibraryStorage;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;

public class StaticLibraries {
    static StaticLibraries instance = new StaticLibraries();
    LibraryStorage libraries = new LibraryStorage();
    Map<File, XModelObject> loadedFolders = new HashMap<File, XModelObject>();
    Map<File, XModelObject> loadedFiles = new HashMap<File, XModelObject>();

    private StaticLibraries() {
    }

    public ITagLibrary[] getLibraries(String uri) {
        XModelObject fo;
        XModelObject o;
        File file = TagLibraryManager.getStaticTLD(uri);
        if (file == null) {
            return new ITagLibrary[0];
        }
        if (this.loadedFiles.containsKey(file)) {
            return this.libraries.getLibrariesArray(uri);
        }
        File folder = file.getParentFile();
        if (!this.loadedFolders.containsKey(folder) && (o = EclipseResourceUtil.createObjectForLocation((String)file.getAbsolutePath())) != null) {
            this.loadedFolders.put(folder, o.getParent());
        }
        if ((o = this.loadedFolders.get(folder)) != null && (fo = o.getChildByPath(file.getName())) != null) {
            this.loadedFiles.put(file, fo);
            XMLScanner scanner = new XMLScanner();
            LoadedDeclarations ds = scanner.parse(fo, (IPath)new Path(file.getAbsolutePath()), null);
            List<ITagLibrary> ls = ds.getLibraries();
            for (ITagLibrary l : ls) {
                this.libraries.addLibrary(l);
            }
        }
        return this.libraries.getLibrariesArray(uri);
    }
}

