/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryStorage {
    private Set<ITagLibrary> allLibraries = new HashSet<ITagLibrary>();
    private ITagLibrary[] allLibrariesArray = null;
    Map<IPath, Set<ITagLibrary>> librariesBySource = new HashMap<IPath, Set<ITagLibrary>>();
    Map<String, Set<ITagLibrary>> librariesByUri = new HashMap<String, Set<ITagLibrary>>();
    private Map<String, ITagLibrary[]> librariesByUriArray = new HashMap<String, ITagLibrary[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.allLibraries;
        synchronized (object) {
            this.allLibraries.clear();
            this.allLibrariesArray = null;
        }
        this.librariesBySource.clear();
        object = this.librariesByUri;
        synchronized (object) {
            this.librariesByUri.clear();
            this.librariesByUriArray.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITagLibrary[] getAllLibrariesArray() {
        if (this.allLibrariesArray == null) {
            Set<ITagLibrary> set = this.allLibraries;
            synchronized (set) {
                this.allLibrariesArray = this.allLibraries.toArray(new ITagLibrary[0]);
            }
        }
        return this.allLibrariesArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITagLibrary[] getLibrariesArray(String uri) {
        ITagLibrary[] result = this.librariesByUriArray.get(uri);
        if (result == null) {
            Map<String, Set<ITagLibrary>> map = this.librariesByUri;
            synchronized (map) {
                Set<ITagLibrary> libs = this.librariesByUri.get(uri);
                result = libs != null ? libs.toArray(new ITagLibrary[0]) : new ITagLibrary[]{};
                this.librariesByUriArray.put(uri, result);
            }
        }
        return result;
    }

    public Set<ITagLibrary> getLibrariesBySource(IPath path) {
        return this.librariesBySource.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibrary(ITagLibrary f) {
        Set<ITagLibrary> set = this.allLibraries;
        synchronized (set) {
            this.allLibraries.add(f);
            this.allLibrariesArray = null;
        }
        IPath path = f.getSourcePath();
        if (path != null) {
            Set<ITagLibrary> fs = this.librariesBySource.get(path);
            if (fs == null) {
                fs = new HashSet<ITagLibrary>();
                this.librariesBySource.put(path, fs);
            }
            fs.add(f);
        }
        String uri = f.getURI();
        Map<String, Set<ITagLibrary>> map = this.librariesByUri;
        synchronized (map) {
            this.librariesByUriArray.remove(uri);
            Set<ITagLibrary> ul = this.librariesByUri.get(uri);
            if (ul == null) {
                ul = new HashSet<ITagLibrary>();
                this.librariesByUri.put(uri, ul);
            }
            ul.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLibrary(ITagLibrary f) {
        Set<ITagLibrary> set = this.allLibraries;
        synchronized (set) {
            this.allLibraries.remove(f);
            this.allLibrariesArray = null;
        }
        IPath path = f.getSourcePath();
        if (path != null) {
            Set<ITagLibrary> fs = this.librariesBySource.get(path);
            if (fs != null) {
                fs.remove(f);
            }
            if (fs.isEmpty()) {
                this.librariesBySource.remove(fs);
            }
        }
        String uri = f.getURI();
        Map<String, Set<ITagLibrary>> map = this.librariesByUri;
        synchronized (map) {
            Set<ITagLibrary> ul = this.librariesByUri.get(uri);
            this.librariesByUriArray.remove(uri);
            if (ul != null) {
                ul.remove(f);
                if (ul.isEmpty()) {
                    this.librariesByUri.remove(uri);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ITagLibrary> removePath(IPath path) {
        Set<ITagLibrary> fs = this.librariesBySource.get(path);
        if (fs == null) {
            return null;
        }
        for (ITagLibrary f : fs) {
            Object object = this.allLibraries;
            synchronized (object) {
                this.allLibraries.remove(f);
                this.allLibrariesArray = null;
            }
            object = this.librariesByUri;
            synchronized (object) {
                Set<ITagLibrary> s = this.librariesByUri.get(f.getURI());
                if (s != null) {
                    s.remove(f);
                }
                if (s != null && s.isEmpty()) {
                    this.librariesByUri.remove(f.getURI());
                }
                this.librariesByUriArray.remove(f.getURI());
            }
        }
        this.librariesBySource.remove(path);
        return fs;
    }
}

