/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.KbResourceVisitor;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;

public class KbBuilder
extends IncrementalProjectBuilder {
    public static String BUILDER_ID = "org.jboss.tools.jst.web.kb.kbbuilder";
    KbResourceVisitor resourceVisitor = null;

    protected KbProject getKbProject() {
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return (KbProject)KbProjectFactory.getKbProject(p, false);
    }

    KbResourceVisitor getResourceVisitor() {
        if (this.resourceVisitor == null) {
            KbProject p = this.getKbProject();
            this.resourceVisitor = new KbResourceVisitor(p);
        }
        return this.resourceVisitor;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        KbProject sp = this.getKbProject();
        if (sp == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        sp.postponeFiring();
        try {
            sp.resolveStorage(kind != 6);
            if (sp.getClassPath().update()) {
                sp.getClassPath().process();
            } else if (sp.getClassPath().hasToUpdateProjectDependencies()) {
                sp.getClassPath().validateProjectDependencies();
            }
            TypeInfoCollector.cleanCache();
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
            long end = System.currentTimeMillis();
            sp.fullBuildTime += end - begin;
            try {
                sp.store();
            }
            catch (IOException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        finally {
            sp.fireChanges();
        }
        this.resourceVisitor = null;
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            PageContextFactory.getInstance().cleanUp(this.getProject());
            this.getProject().accept(this.getResourceVisitor().getVisitor());
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        PageContextFactory.getInstance().cleanUp(delta);
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
    }

    public static IFileScanner getXMLScanner() {
        return new XMLScanner();
    }

    public static IFileScanner getLibraryScanner() {
        return new LibraryScanner();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        KbProject sp = this.getKbProject();
        if (sp != null) {
            sp.clean();
        }
        PageContextFactory.getInstance().cleanUp(this.getProject());
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return KbBuilder.this.getResourceVisitor().getVisitor().visit(resource);
                }
                case 2: {
                    KbProject p = KbBuilder.this.getKbProject();
                    if (p == null) break;
                    p.pathRemoved(resource.getFullPath());
                    break;
                }
                case 4: {
                    return KbBuilder.this.getResourceVisitor().getVisitor().visit(resource);
                }
            }
            return true;
        }
    }
}

