/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IFaceletPageContext;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.taglib.CustomTagLibManager;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.IFacesConfigTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageProcessor {
    private static final PageProcessor INSTANCE = new PageProcessor();
    private ICustomTagLibrary[] customTagLibs = CustomTagLibManager.getInstance().getLibraries();
    private CustomTagLibAttribute[] componentExtensions = CustomTagLibManager.getInstance().getComponentExtensions();
    private static final IAttribute[] EMPTY_ATTRIBUTE_ARRAY = new IAttribute[0];

    public static PageProcessor getInstance() {
        return INSTANCE;
    }

    private PageProcessor() {
    }

    public TextProposal[] getProposals(KbQuery query, ELContext context) {
        ArrayList<TextProposal> proposals;
        block13: {
            String value;
            block12: {
                int j;
                TextProposal[] libProposals;
                proposals = new ArrayList<TextProposal>();
                if (this.isQueryForELProposals(query, context)) break block12;
                if (!(context instanceof IPageContext)) break block13;
                IPageContext pageContext = (IPageContext)context;
                ITagLibrary[] libs = pageContext.getLibraries();
                int i = 0;
                while (libs != null && i < libs.length) {
                    if (!(libs[i] instanceof IFacesConfigTagLibrary)) {
                        libProposals = libs[i].getProposals(query, pageContext);
                        j = 0;
                        while (libProposals != null && j < libProposals.length) {
                            proposals.add(libProposals[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
                    HashMap<String, IAttribute> attrbMap = new HashMap<String, IAttribute>();
                    for (TextProposal proposal : proposals) {
                        if (proposal.getSource() == null || !(proposal.getSource() instanceof IAttribute)) continue;
                        IAttribute att = (IAttribute)proposal.getSource();
                        attrbMap.put(att.getName(), att);
                    }
                    IAttribute[] attrs = this.getAttributes(query, pageContext, false);
                    int i2 = 0;
                    while (i2 < attrs.length) {
                        attrbMap.put(attrs[i2].getName(), attrs[i2]);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < this.componentExtensions.length) {
                        if (attrbMap.containsKey(this.componentExtensions[i2].getName())) {
                            TextProposal[] attProposals = this.componentExtensions[i2].getProposals(query, pageContext);
                            int j2 = 0;
                            while (j2 < attProposals.length) {
                                proposals.add(attProposals[j2]);
                                ++j2;
                            }
                        }
                        ++i2;
                    }
                }
                i = 0;
                while (this.customTagLibs != null && i < this.customTagLibs.length) {
                    libProposals = this.customTagLibs[i].getProposals(query, pageContext);
                    j = 0;
                    while (libProposals != null && j < libProposals.length) {
                        proposals.add(libProposals[j]);
                        ++j;
                    }
                    ++i;
                }
                break block13;
            }
            String elString = value = query.getValue();
            ELResolver[] resolvers = context.getElResolvers();
            int i = 0;
            while (resolvers != null && i < resolvers.length) {
                proposals.addAll(resolvers[i].getProposals(context, elString, query.getOffset()));
                ++i;
            }
        }
        return proposals.toArray(new TextProposal[proposals.size()]);
    }

    private boolean isQueryForELProposals(KbQuery query, ELContext context) {
        if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE || query.getType() == KbQuery.Type.TEXT && (context instanceof IFaceletPageContext || context instanceof XmlContextImpl)) {
            return query.getValue() != null && (query.getValue().startsWith("#{") || query.getValue().startsWith("${"));
        }
        return false;
    }

    public IComponent[] getComponents(KbQuery query, IPageContext context) {
        return this.getComponents(query, context, false);
    }

    public IComponent[] getComponents(KbQuery query, IPageContext context, boolean includeComponentExtensions) {
        int j;
        IComponent[] libComponents;
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        ITagLibrary[] libs = context.getLibraries();
        int i = 0;
        while (i < libs.length) {
            if (!(libs[i] instanceof IFacesConfigTagLibrary)) {
                libComponents = libs[i].getComponents(query, context);
                j = 0;
                while (j < libComponents.length) {
                    if (includeComponentExtensions || !libComponents[j].isExtended()) {
                        components.add(libComponents[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (this.customTagLibs != null && i < this.customTagLibs.length) {
            libComponents = this.customTagLibs[i].getComponents(query, context);
            j = 0;
            while (j < libComponents.length) {
                if (includeComponentExtensions || !libComponents[j].isExtended()) {
                    components.add(libComponents[j]);
                }
                ++j;
            }
            ++i;
        }
        return components.toArray(new IComponent[components.size()]);
    }

    public IAttribute[] getAttributes(KbQuery query, IPageContext context) {
        return this.getAttributes(query, context, true);
    }

    private IAttribute[] getAttributes(KbQuery query, IPageContext context, boolean includeComponentExtensions) {
        if (query.getType() == KbQuery.Type.ATTRIBUTE_NAME || query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
            ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
            HashMap<String, IAttribute> attrbMap = new HashMap<String, IAttribute>();
            IComponent[] components = this.getComponents(query, context, includeComponentExtensions);
            int i = 0;
            while (i < components.length) {
                IAttribute[] libAttributess = components[i].getAttributes(query, context);
                int j = 0;
                while (j < libAttributess.length) {
                    attributes.add(libAttributess[j]);
                    attrbMap.put(libAttributess[j].getName(), libAttributess[j]);
                    ++j;
                }
                ++i;
            }
            if (includeComponentExtensions) {
                i = 0;
                while (i < this.componentExtensions.length) {
                    if (attrbMap.containsKey(this.componentExtensions[i].getName())) {
                        attributes.add(this.componentExtensions[i]);
                    }
                    ++i;
                }
            }
            return attributes.toArray(new IAttribute[attributes.size()]);
        }
        return EMPTY_ATTRIBUTE_ARRAY;
    }

    public Map<String, IAttribute> getAttributesAsMap(KbQuery query, IPageContext context) {
        IAttribute[] as = this.getAttributes(query, context);
        HashMap<String, IAttribute> map = new HashMap<String, IAttribute>();
        IAttribute[] iAttributeArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute a = iAttributeArray[n2];
            String n3 = a.getName();
            if (!map.containsKey(n3) || a instanceof CustomTagLibAttribute) {
                map.put(n3, a);
            }
            ++n2;
        }
        return map;
    }
}

