/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.jst.web.context.ImportWebWarContext;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.project.ImportWebWarWizardPage;

public abstract class ImportWebWarWizard
extends Wizard
implements IImportWizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected ImportWebWarWizardPage mainPage;
    protected ImportWebWarContext context;

    public ImportWebWarWizard() {
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    protected void installMainPage() {
        this.mainPage = new ImportWebWarWizardPage(this.context);
        String mainPageTitle = WizardKeys.getString((String)(((Object)((Object)this)).getClass().getName() + ".mainPageTitle"));
        this.mainPage.setTitle(mainPageTitle);
        String mainPageDescr = WizardKeys.getString((String)(ImportWebWarWizard.class.getName() + ".mainPagePrompt"));
        this.mainPage.setDescription(mainPageDescr);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        if (this.mainPage == null) {
            return false;
        }
        return this.mainPage.isPageComplete() && this.context.canFinish();
    }

    public boolean performFinish() {
        boolean result = true;
        this.mainPage.commit();
        this.context.setServletVersion("2.4");
        if (!this.context.isServletVersionConsistentToWebXML()) {
            this.context.setServletVersion("2.3");
        }
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.createOperation());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InterruptedException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        this.updatePerspective();
        BasicNewResourceWizard.selectAndReveal((IResource)this.context.getProjectHandle(), (IWorkbenchWindow)ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
        return result;
    }

    protected abstract IRunnableWithProgress createOperation();

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)new ConfigurationElementInternal());
    }

    protected String getFinalPerspective() {
        return "org.jboss.tools.jst.web.ui.WebDevelopmentPerspective";
    }

    private class ConfigurationElementInternal
    implements IConfigurationElement {
        private ConfigurationElementInternal() {
        }

        public Object getParent() {
            return null;
        }

        public String getAttribute(String name) {
            return "finalPerspective".equals(name) ? ImportWebWarWizard.this.getFinalPerspective() : null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getAttributeAsIs(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String[] getAttributeNames() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public IConfigurationElement[] getChildren() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public IConfigurationElement[] getChildren(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public IExtension getDeclaringExtension() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getValue() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getValueAsIs() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Class loadExtensionClass(String propertyName) throws CoreException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

