/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.appregister;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.wizard.NewServerWizard;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewRuntimeWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IMutableFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.MutableComboBoxFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.MutableMultipleChoiceFieldEditor;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.server.ServerManager;
import org.jboss.tools.jst.web.ui.Messages;

public class AppRegisterComponent {
    static String ENTITY = "WebPrjRegisterApplication";
    static String ATTR_REGISTER = "register";
    static String ATTR_LOCATION = "location";
    static String ATTR_APP_NAME = "application name";
    static String ATTR_RUNTIME = "runtime";
    static String ATTR_TARGET_SERVER = "target server";
    static String ATTR_SEPARATOR = "separator";
    RegisterServerContext context;
    boolean isEnabling = true;
    XAttributeSupport enableSupport;
    private IModelPropertyEditorAdapter enableAdapter;
    XAttributeSupport support;
    Layout supportLayout;
    Composite supportControl;
    AddServer addServer = new AddServer();
    AddRuntime addRuntime = new AddRuntime();

    public void setLight(boolean b) {
    }

    public void setLayoutForSupport(Layout layout) {
        this.supportLayout = layout;
    }

    public void dispose() {
        if (this.enableSupport != null) {
            this.enableSupport.dispose();
        }
        this.enableSupport = null;
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.enableAdapter != null) {
            this.enableAdapter.dispose();
        }
        this.enableAdapter = null;
        this.context = null;
    }

    public void setEnabling(boolean b) {
        this.isEnabling = b;
    }

    public void setContext(RegisterServerContext context) {
        this.context = context;
    }

    public void init() {
        XModelObject dummy = PreferenceModelUtilities.getPreferenceModel().getRoot();
        String[][] attInfo = null;
        attInfo = new String[][]{{ENTITY, ""}, {ATTR_APP_NAME, "yes"}, {ATTR_RUNTIME, "yes"}, {ATTR_SEPARATOR, "no"}, {ATTR_TARGET_SERVER, "no"}};
        XEntityDataImpl entityData = XEntityDataImpl.create((String[][])attInfo);
        this.support = new XAttributeSupport(){

            protected boolean keepGreedy(String name, int index, int greedyCount) {
                return true;
            }
        };
        this.support.init(dummy, (XEntityData)entityData);
        entityData = XEntityDataImpl.create((String[][])new String[][]{{ENTITY, ""}, {ATTR_REGISTER, "no"}});
        if (this.isEnabling()) {
            this.enableSupport = new XAttributeSupport();
            this.enableSupport.init(dummy, (XEntityData)entityData);
            this.enableAdapter = this.enableSupport.getPropertyEditorAdapterByName(ATTR_REGISTER);
            this.enableAdapter.addValueChangeListener((PropertyChangeListener)new EnableAdapterListener());
        }
        this.initValues();
        IModelPropertyEditorAdapter a = this.support.getPropertyEditorAdapterByName(ATTR_TARGET_SERVER);
        a.addValueChangeListener((PropertyChangeListener)new ServerInputChangeListener());
        a = this.support.getPropertyEditorAdapterByName(ATTR_RUNTIME);
        a.addValueChangeListener((PropertyChangeListener)new RuntimeInputChangeListener());
    }

    public boolean isEnabling() {
        return this.isEnabling;
    }

    public void loadApplicationName() {
        String n = this.context.getApplicationName() == null ? "" : this.context.getApplicationName();
        this.support.getPropertyEditorAdapterByName(ATTR_APP_NAME).setValue((Object)n);
    }

    public String getApplicationName() {
        return this.support.getPropertyEditorAdapterByName(ATTR_APP_NAME).getStringValue(true);
    }

    public Control createControl(Composite parent) {
        return this.isEnabling() ? this.createEnablingControl(parent) : this.createEnabledControl(parent);
    }

    public Control createEnablingControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        c.setLayout((Layout)layout);
        this.enableSupport.setLayout(this.getEnablingLayout());
        this.enableSupport.createControl(c);
        this.setLableText(this.enableSupport, "register");
        Group group = new Group(c, 16);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        this.createSupportControl((Composite)group);
        this.updateEnablement();
        return c;
    }

    private void setLableText(XAttributeSupport s, String field) {
        ExtendedFieldEditor f = (ExtendedFieldEditor)s.getFieldEditorByName(field);
        if (f == null) {
            return;
        }
        String t = f.getLabelText();
        int i = t.indexOf("%1");
        if (i < 0) {
            return;
        }
        String insert = "";
        IServer server = ServerManager.getInstance().getSelectedServer();
        insert = server != null ? server.getServerType().getName() : "server";
        t = String.valueOf(t.substring(0, i)) + insert + t.substring(i + 2);
        f.setLabelText(t);
    }

    public Control createEnabledControl(Composite parent) {
        Control sc = this.createSupportControl(parent);
        this.updateEnablement();
        return sc;
    }

    private Control createSupportControl(Composite parent) {
        if (this.supportLayout != null) {
            this.support.setLayout(this.supportLayout);
        }
        Composite sc = this.support.createControl(parent);
        this.setLableText(this.support, "location");
        this.supportControl = sc;
        GridData g2 = new GridData(768);
        g2.horizontalIndent = 0;
        sc.setLayoutData((Object)g2);
        IMutableFieldEditor editor = (IMutableFieldEditor)this.support.getFieldEditorByName(ATTR_TARGET_SERVER);
        editor.setChange((SpecialWizard)this.addServer);
        editor = (IMutableFieldEditor)this.support.getFieldEditorByName(ATTR_RUNTIME);
        editor.setChange((SpecialWizard)this.addRuntime);
        return sc;
    }

    Layout getEnablingLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        return gridLayout;
    }

    private void initValues() {
        if (this.isEnabling()) {
            this.enableSupport.getEntityData().setValue(ATTR_REGISTER, this.context.isEnabled() ? "yes" : "no");
            this.enableSupport.load();
        }
        String n = this.context.getApplicationName() == null ? "" : this.context.getApplicationName();
        this.support.getEntityData().setValue(ATTR_APP_NAME, n);
        this.initRuntimeValue();
        this.initTargetServerValue();
        this.support.load();
    }

    void initRuntimeValue() {
        IRuntime[] rs = ServerCore.getRuntimes();
        IServer selectedServer = ServerManager.getInstance().getSelectedServer();
        IRuntime selectedRuntime = selectedServer != null ? selectedServer.getRuntime() : null;
        IRuntime selectedRuntime1 = null;
        String[] ns = new String[rs.length];
        int i = 0;
        while (i < rs.length) {
            ns[i] = rs[i].getName();
            if (rs[i] == selectedRuntime || selectedRuntime1 == null) {
                selectedRuntime1 = rs[i];
            }
            ++i;
        }
        IProject p = this.context.getProjectHandle();
        if (p != null && p.exists() && p.isAccessible()) {
            try {
                IRuntime sr = J2EEProjectUtilities.getServerRuntime((IProject)p);
                if (sr != null) {
                    selectedRuntime1 = sr;
                }
            }
            catch (CoreException exc) {
                WebModelPlugin.getPluginLog().logError((Throwable)exc);
            }
        }
        HUtil.hackAttributeConstraintList((XEntityData[])new XEntityData[]{this.support.getEntityData()}, (int)0, (String)ATTR_RUNTIME, (String[])ns);
        String runtimeName = selectedRuntime1 != null ? selectedRuntime1.getName() : "";
        this.context.setRuntimeName(runtimeName);
        this.support.getEntityData().setValue(ATTR_RUNTIME, runtimeName);
    }

    void initTargetServerValue() {
        String runtimeName = this.context.getRuntimeName();
        IServer[] is = ServerCore.getServers();
        IServer selected = null;
        IServer selected1 = null;
        ArrayList<String> l = new ArrayList<String>();
        IServer sel = ServerManager.getInstance().getSelectedServer();
        if (sel != null) {
            selected = sel;
        }
        int i = 0;
        while (i < is.length) {
            if (is[i].getRuntime() != null && runtimeName.equals(is[i].getRuntime().getName())) {
                if (selected == is[i] || selected1 == null) {
                    selected1 = is[i];
                }
                l.add(is[i].getName());
            }
            ++i;
        }
        String[] vs = l.toArray(new String[0]);
        HUtil.hackAttributeConstraintList((XEntityData[])new XEntityData[]{this.support.getEntityData()}, (int)0, (String)ATTR_TARGET_SERVER, (String[])vs);
        selected = selected1;
        if (selected != null && this.context.isInitiallyEnabled()) {
            this.context.setTargetServers(new IServer[]{selected});
            this.support.getEntityData().setValue(ATTR_TARGET_SERVER, selected.getName());
        } else {
            this.context.setTargetServers(new IServer[0]);
            this.support.getEntityData().setValue(ATTR_TARGET_SERVER, "");
        }
    }

    void updateEnablement() {
        if (this.supportControl == null || this.supportControl.isDisposed()) {
            return;
        }
        boolean enabled = this.isRegisterEnabled();
        this.support.getPropertyEditorByName(ATTR_APP_NAME).getFieldEditor(this.supportControl).setEnabled(enabled, this.supportControl);
        this.support.getPropertyEditorByName(ATTR_TARGET_SERVER).getFieldEditor(this.supportControl).setEnabled(enabled, this.supportControl);
    }

    boolean isRegisterEnabled() {
        return !this.isEnabling() || "yes".equals(this.enableAdapter.getValue());
    }

    public String getErrorMessage() {
        this.commit();
        return this.context.getErrorMessage();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
        if (this.isEnabling()) {
            this.enableSupport.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
        if (this.isEnabling()) {
            this.enableSupport.removePropertyChangeListener(listener);
        }
    }

    public void commit() {
        Properties p = this.support.getValues();
        this.context.setApplicationName(p.getProperty(ATTR_APP_NAME));
        this.context.setEnabled(this.isRegisterEnabled());
    }

    void onRuntimeChange(String value) {
        String string = value = value == null ? "" : value.trim();
        if (value.equals(this.context.getRuntimeName())) {
            return;
        }
        this.context.setRuntimeName(value);
        this.initTargetServerValue();
        MutableMultipleChoiceFieldEditor ed = (MutableMultipleChoiceFieldEditor)this.support.getFieldEditorByName(ATTR_TARGET_SERVER);
        ed.propertyChange(new PropertyChangeEvent(this, "IPropertyEditor.listContent", "old", "new"));
    }

    void onTargetServerChange(String value) {
        ArrayList<IServer> list = new ArrayList<IServer>();
        String[] s = XModelObjectUtil.asStringArray((String)value);
        IServer[] is = ServerCore.getServers();
        int i = 0;
        while (i < is.length) {
            int j = 0;
            while (j < s.length) {
                if (is[i].getName().equals(s[j])) {
                    if (list.contains(is[i])) break;
                    list.add(is[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.context.setTargetServers(list.toArray(new IServer[0]));
    }

    private IServer newServer(Shell shell) {
        NewServerWizard wizard = new NewServerWizard();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 1) {
            return null;
        }
        IServer server = (IServer)wizard.getRootFragment().getTaskModel().getObject("server");
        if (server == null) {
            return null;
        }
        ServerManager.getInstance().setSelectedServer(server.getId());
        return server;
    }

    private IRuntime newRuntime(Shell shell) {
        WizardFragment fragment = null;
        String title = Messages.AppRegisterComponent_NewServerRuntime;
        fragment = new WizardFragment(){

            protected void createChildFragments(List list) {
                list.add(new NewRuntimeWizardFragment());
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(title, fragment);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        return (IRuntime)wizard.getRootFragment().getTaskModel().getObject("runtime");
    }

    class AddRuntime
    implements SpecialWizard {
        Properties p;

        AddRuntime() {
        }

        public void setObject(Object object) {
            this.p = (Properties)object;
        }

        public int execute() {
            Shell shell = (Shell)this.p.get("shell");
            IRuntime runtime = AppRegisterComponent.this.newRuntime(shell);
            if (runtime == null) {
                return -1;
            }
            this.p.setProperty("value", runtime.getName());
            AppRegisterComponent.this.initRuntimeValue();
            AppRegisterComponent.this.context.setRuntimeName("");
            return 0;
        }
    }

    class AddServer
    implements SpecialWizard {
        Properties p;

        AddServer() {
        }

        public void setObject(Object object) {
            this.p = (Properties)object;
        }

        public int execute() {
            Shell shell = (Shell)this.p.get("shell");
            IServer server = AppRegisterComponent.this.newServer(shell);
            if (server == null) {
                return -1;
            }
            IModelPropertyEditorAdapter a = AppRegisterComponent.this.support.getPropertyEditorAdapterByName(ATTR_RUNTIME);
            if (server.getRuntime() != null && !server.getRuntime().getName().equals(a.getValue())) {
                MutableComboBoxFieldEditor ed1 = (MutableComboBoxFieldEditor)AppRegisterComponent.this.support.getFieldEditorByName(ATTR_RUNTIME);
                ed1.setNewValue(server.getRuntime().getName());
            }
            this.p.setProperty("value", server.getName());
            AppRegisterComponent.this.initTargetServerValue();
            MutableMultipleChoiceFieldEditor ed = (MutableMultipleChoiceFieldEditor)AppRegisterComponent.this.support.getFieldEditorByName(ATTR_TARGET_SERVER);
            ed.propertyChange(new PropertyChangeEvent(this, "IPropertyEditor.listContent", "old", "new"));
            return 0;
        }
    }

    class EnableAdapterListener
    implements PropertyChangeListener {
        EnableAdapterListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AppRegisterComponent.this.updateEnablement();
        }
    }

    class RuntimeInputChangeListener
    implements PropertyChangeListener {
        RuntimeInputChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String value = (String)evt.getNewValue();
            AppRegisterComponent.this.onRuntimeChange(value);
        }
    }

    class ServerInputChangeListener
    implements PropertyChangeListener {
        ServerInputChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String value = (String)evt.getNewValue();
            AppRegisterComponent.this.onTargetServerChange(value);
        }
    }
}

