/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.operation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.project.helpers.ProjectTemplate;

public class TemplatePreprocessor {
    File sourceDir;
    File targetDir;
    Map parameters;

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void execute() throws Exception {
        File preprocessing = new File(this.sourceDir, ProjectTemplate.PREPROCESSING);
        if (!preprocessing.isFile()) {
            return;
        }
        String content = FileUtil.readFile((File)preprocessing);
        StringTokenizer st = new StringTokenizer(content, "\r\n,;");
        while (st.hasMoreTokens()) {
            String path = st.nextToken().trim();
            if (path.length() <= 0) continue;
            this.process(path);
        }
        preprocessing = new File(this.targetDir, ProjectTemplate.PREPROCESSING);
        if (preprocessing.isFile()) {
            preprocessing.delete();
        }
    }

    void process(String path) throws Exception {
        File sourceFile = new File(this.sourceDir, path);
        File targetFile = new File(this.targetDir, path);
        if (!sourceFile.exists()) {
            return;
        }
        Properties properties = new Properties();
        properties.put("file.resource.loader.path", this.sourceDir.getCanonicalPath());
        String logFileName = Platform.getLocation().append(".metadata").append(".plugins").append("org.jboss.tools.jst.web.ui").append("velocity.log").toFile().getAbsolutePath();
        properties.put("runtime.log", logFileName);
        Velocity.init((Properties)properties);
        VelocityContext context = new VelocityContext(this.parameters);
        File file = targetFile;
        if (file.exists() && !file.delete()) {
            throw new RuntimeException("Unable to delete file " + file.getAbsolutePath());
        }
        File folder = file.getParentFile();
        folder.mkdirs();
        if (!folder.exists() || !folder.isDirectory()) {
            throw new RuntimeException("Unable to create folder " + folder.getAbsolutePath());
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
        Velocity.evaluate((Context)context, (Writer)writer, (String)"", (Reader)reader);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }
}

