/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.browser.util;

import java.io.PrintStream;
import java.util.List;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMTreeDumper {
    private PrintStream ps = System.out;
    private boolean inA;
    private boolean printHashCode;
    private final String[] endTagForbiddenNames = new String[]{"AREA", "BASE", "BASEFONT", "BR", "COL", "FRAME", "HR", "IMG", "INPUT", "ISINDEX", "LINK", "META", "PARAM"};
    private List<String> ignoredAttributes = null;

    public DOMTreeDumper() {
        this.printHashCode = true;
    }

    public DOMTreeDumper(boolean isPrintHashCode) {
        this.printHashCode = isPrintHashCode;
    }

    public boolean isPrintHashCode() {
        return this.printHashCode;
    }

    public void setPrintHashCode(boolean printHashCode) {
        this.printHashCode = printHashCode;
    }

    public void dumpToStream(PrintStream ps, nsIDOMDocument doc) {
        this.ps = ps;
        this.dumpDocument(doc);
    }

    public void dumpToStream(PrintStream ps, nsIDOMElement element) {
        this.ps = ps;
        this.dumpNode((nsIDOMNode)element.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"));
        ps.println();
        ps.flush();
    }

    private void dumpDocument(nsIDOMDocument doc) {
        if (doc == null) {
            return;
        }
        nsIDOMElement element = doc.getDocumentElement();
        if (element == null) {
            return;
        }
        this.dumpNode((nsIDOMNode)element.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"));
        this.ps.println();
        this.ps.flush();
        element = null;
        doc = null;
    }

    public void dumpNode(nsIDOMNode node) {
        this.dumpNode(node, false);
    }

    private void dumpNode(nsIDOMNode node, boolean isMapNode) {
        if (node == null) {
            return;
        }
        int type = node.getNodeType();
        String name = node.getNodeName();
        String value = node.getNodeValue();
        switch (type) {
            case 1: {
                if (name.equals("A")) {
                    this.inA = true;
                }
                if (!this.inA && !name.equals("BR")) {
                    this.ps.println();
                }
                this.ps.print("<" + name);
                this.dumpAttributes(node);
                if (this.endTagForbidden(name)) {
                    this.ps.print("/>");
                } else {
                    this.ps.print(">");
                }
                this.printHashCode(node);
                this.dumpChildren(node);
                if (name.equals("A")) {
                    this.inA = false;
                }
                if (this.endTagForbidden(name)) break;
                this.ps.print("</" + name + ">");
                break;
            }
            case 2: {
                nsIDOMAttr attr = (nsIDOMAttr)node.queryInterface("{a6cf9070-15b3-11d2-932e-00805f8add32}");
                if (this.ignoredAttributes != null && this.listContains(this.ignoredAttributes, attr.getName())) break;
                if (attr.getSpecified()) {
                    this.ps.print(" " + attr.getName().toUpperCase() + "=\"" + attr.getValue() + "\"");
                    break;
                }
                this.ps.print(" " + attr.getName().toUpperCase());
                break;
            }
            case 3: {
                if (!node.getParentNode().getNodeName().equals("PRE")) {
                    value = value.trim();
                }
                if (!value.equals("")) {
                    if (!this.inA) {
                        this.ps.println();
                    }
                    this.ps.print(this.canonicalize(value));
                }
                this.printHashCode(node);
                break;
            }
            case 8: {
                this.ps.print("\n<!--" + value + "-->");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.ps.println("\n<!-- NOT HANDLED: " + name + "  value=" + value + " -->");
            }
        }
    }

    private void dumpAttributes(nsIDOMNode node) {
        nsIDOMNamedNodeMap map = node.getAttributes();
        if (map == null) {
            return;
        }
        long length = map.getLength();
        int i = 0;
        while ((long)i < length) {
            this.dumpNode(map.item((long)i), true);
            ++i;
        }
    }

    private void dumpChildren(nsIDOMNode node) {
        nsIDOMNodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        long length = children.getLength();
        int i = 0;
        while ((long)i < length) {
            this.dumpNode(children.item((long)i));
            ++i;
        }
        if (!this.inA) {
            this.ps.println();
        }
    }

    private String canonicalize(String str) {
        StringBuffer in = new StringBuffer(str);
        int length = in.length();
        StringBuffer out = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = in.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\u00a0': {
                    out.append("&nbsp;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    private boolean endTagForbidden(String name) {
        int i = 0;
        while (i < this.endTagForbiddenNames.length) {
            if (name.equals(this.endTagForbiddenNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean listContains(List<String> list, String string) {
        for (String listString : list) {
            if (!string.equalsIgnoreCase(listString)) continue;
            return true;
        }
        return false;
    }

    private void printHashCode(Object o) {
        if (this.isPrintHashCode()) {
            this.ps.print("(" + o.hashCode() + ")");
        }
    }

    public List<String> getIgnoredAttributes() {
        return this.ignoredAttributes;
    }

    public void setIgnoredAttributes(List<String> ignoredAttributes) {
        this.ignoredAttributes = ignoredAttributes;
    }
}

