/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.browser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.jboss.tools.vpe.xulrunner.XulRunnerException;
import org.jboss.tools.vpe.xulrunner.browser.AppFileLocProvider;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIPrefService;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsITooltipListener;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWebBrowserSetup;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.GREVersionRange;
import org.mozilla.xpcom.IAppFileLocProvider;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.osgi.framework.Bundle;

public class XulRunnerBrowser
implements nsIWebBrowserChrome,
nsIWebProgressListener,
nsITooltipListener {
    private static final String XULRUNNER_LOWER_VERSION = "1.9.1.0";
    private static final String XULRUNNER_HIGHER_VERSION = "1.9.1.9";
    private static final String XULRUNNER_BUNDLE = new StringBuffer("org.mozilla.xulrunner").append(".").append(Platform.getWS()).append(".").append(Platform.getOS()).append("macosx".equals(Platform.getOS()) ? "" : new StringBuffer(".").append(Platform.getOSArch()).toString()).toString();
    private static final String XULRUNNER_ENTRY = "/xulrunner";
    static final String XULRUNNER_INITIALIZED = "org.eclipse.swt.browser.XULRunnerInitialized";
    static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";
    private static final String ROOT_BRANCH_NAME = "";
    private static final String PREFERENCE_DISABLEOPENDURINGLOAD = "dom.disable_open_during_load";
    private static final String PREFERENCE_DISABLEWINDOWSTATUSCHANGE = "dom.disable_window_status_change";
    private static final Mozilla mozilla = Mozilla.getInstance();
    private Browser browser = null;
    private nsIWebBrowser webBrowser = null;
    private long chrome_flags = 4094L;
    protected static final long NS_ERROR_FAILURE = 2147500037L;

    public XulRunnerBrowser(Composite parent) throws XulRunnerException {
        this.browser = new Browser(parent, 32768);
        this.webBrowser = (nsIWebBrowser)this.browser.getWebBrowser();
        if (this.webBrowser == null) {
            throw new XulRunnerException("nsIWebBrowser is not available");
        }
        this.setBoolRootPref(PREFERENCE_DISABLEOPENDURINGLOAD, true);
        this.setBoolRootPref(PREFERENCE_DISABLEWINDOWSTATUSCHANGE, true);
        nsIWebBrowserSetup setup = (nsIWebBrowserSetup)this.webBrowser.queryInterface("{f15398a0-8018-11d3-af70-00a024ffc08c}");
        setup.setProperty(7L, 1L);
        nsIServiceManager serviceManager = mozilla.getServiceManager();
        nsIWebProgress webProgress = (nsIWebProgress)serviceManager.getServiceByContractID("@mozilla.org/docloaderservice;1", "{570f39d0-efd0-11d3-b093-00a024ffc08c}");
        webProgress.addProgressListener((nsIWebProgressListener)this, 15L);
        this.webBrowser.addWebBrowserListener((nsISupports)this, "{44b78386-1dd2-11b2-9ad2-e4eee2ca1916}");
    }

    public synchronized void initXulRunner() throws XulRunnerException {
        String xulRunnerPath = XulRunnerBrowser.getXulRunnerPath();
        if (!"true".equals(System.getProperty(XULRUNNER_INITIALIZED))) {
            File file = new File(xulRunnerPath);
            mozilla.initialize(file);
            mozilla.initEmbedding(file, file, (IAppFileLocProvider)new AppFileLocProvider(file));
            System.setProperty(XULRUNNER_INITIALIZED, "true");
        }
    }

    public Display getDisplay() {
        return this.browser.getDisplay();
    }

    public void setCursor(Cursor cursor) {
        this.browser.setCursor(cursor);
    }

    public boolean setFocus() {
        return this.browser.setFocus();
    }

    public void setLayoutData(Object layoutData) {
        this.browser.setLayoutData(layoutData);
    }

    public void addListener(int eventType, Listener listener) {
        this.browser.addListener(eventType, listener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.browser.removeListener(eventType, listener);
    }

    public void dispose() {
        this.removeProgressListener(this);
        this.browser.dispose();
        this.browser = null;
    }

    public static String getXulRunnerBundle() {
        return XULRUNNER_BUNDLE;
    }

    public static synchronized String getXulRunnerPath() throws XulRunnerException {
        String xulRunnerPath = System.getProperty(XULRUNNER_PATH);
        if (xulRunnerPath == null) {
            GREVersionRange[] greRanges = new GREVersionRange[]{new GREVersionRange(XULRUNNER_LOWER_VERSION, true, XULRUNNER_HIGHER_VERSION, true)};
            File xulRunnerFile = null;
            Bundle xulRunnerBundle = Platform.getBundle((String)XulRunnerBrowser.getXulRunnerBundle());
            if (xulRunnerBundle == null) {
                throw new XulRunnerException("Bundle " + XulRunnerBrowser.getXulRunnerBundle() + " is not found.");
            }
            String xulRunnerVersion = (String)xulRunnerBundle.getHeaders().get("Bundle-Version");
            if (!greRanges[0].check(xulRunnerVersion)) {
                throw new XulRunnerException("the version of the bundled XULRunner must be >= 1.9.1.0 and <= 1.9.1.9");
            }
            URL url = xulRunnerBundle.getEntry(XULRUNNER_ENTRY);
            if (url == null) {
                throw new XulRunnerException("Bundle " + XulRunnerBrowser.getXulRunnerBundle() + " doesn't contain " + XULRUNNER_ENTRY);
            }
            try {
                URL url1 = FileLocator.resolve((URL)url);
                xulRunnerFile = new File(FileLocator.toFileURL((URL)url1).getFile());
            }
            catch (IOException ioe) {
                throw new XulRunnerException("Cannot get path to XULRunner from bundle " + XulRunnerBrowser.getXulRunnerBundle(), ioe);
            }
            xulRunnerPath = xulRunnerFile.getAbsolutePath();
            System.setProperty(XULRUNNER_PATH, xulRunnerPath);
        }
        return xulRunnerPath;
    }

    public nsIServiceManager getServiceManager() {
        return mozilla.getServiceManager();
    }

    public nsIComponentManager getComponentManager() {
        return mozilla.getComponentManager();
    }

    public void setURL(String url) {
        nsIWebNavigation webNavigation = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        webNavigation.loadURI(url, 0L, null, null, null);
    }

    public String getURL() {
        nsIWebNavigation webNavigation = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        return webNavigation.getCurrentURI().getSpec();
    }

    public void stop() {
        nsIWebNavigation webNavigation = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        webNavigation.stop(3L);
    }

    public void reload() {
        nsIWebNavigation webNavigation = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        webNavigation.reload(0L);
    }

    public void goBack() {
        nsIWebNavigation webNavigation = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        webNavigation.goBack();
    }

    public void goForward() {
        nsIWebNavigation webNavigation = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        webNavigation.goForward();
    }

    public void onLoadWindow() {
    }

    public nsIPrefService getPrefService() {
        return (nsIPrefService)this.getServiceManager().getServiceByContractID("@mozilla.org/preferences-service;1", "{decb9cc7-c08f-4ea5-be91-a8fc637ce2d2}");
    }

    public void setBoolRootPref(String aPrefName, boolean aValue) {
        this.getPrefService().getBranch(ROOT_BRANCH_NAME).setBoolPref(aPrefName, aValue ? 1 : 0);
    }

    public void setCharRootPref(String aPrefName, String aValue) {
        this.getPrefService().getBranch(ROOT_BRANCH_NAME).setCharPref(aPrefName, aValue);
    }

    public void setComplexRootValue(String aPrefName, String aType, nsISupports aValue) {
        this.getPrefService().getBranch(ROOT_BRANCH_NAME).setComplexValue(aPrefName, aType, aValue);
    }

    public void setIntRootPref(String aPrefName, int aValue) {
        this.getPrefService().getBranch(ROOT_BRANCH_NAME).setIntPref(aPrefName, aValue);
    }

    public boolean getBoolRootPref(String aPrefName) {
        return this.getPrefService().getBranch(ROOT_BRANCH_NAME).getBoolPref(aPrefName);
    }

    public String getCharRootPref(String aPrefName) {
        return this.getPrefService().getBranch(ROOT_BRANCH_NAME).getCharPref(aPrefName);
    }

    public nsISupports getComplextRootPref(String aPrefName, String aType) {
        return this.getPrefService().getBranch(ROOT_BRANCH_NAME).getComplexValue(aPrefName, aType);
    }

    public int getIntRootf(String aPrefName) {
        return this.getPrefService().getBranch(ROOT_BRANCH_NAME).getIntPref(aPrefName);
    }

    public nsISupports queryInterface(String arg0) {
        return Mozilla.queryInterface((nsISupports)this, (String)arg0);
    }

    public void destroyBrowserWindow() {
        throw new RuntimeException("Not implemented");
    }

    public void exitModalEventLoop(long arg0) {
        throw new RuntimeException("Not implemented");
    }

    public long getChromeFlags() {
        return this.chrome_flags;
    }

    public nsIWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public boolean isWindowModal() {
        return false;
    }

    public void setChromeFlags(long arg0) {
        this.chrome_flags = arg0;
    }

    public void setStatus(long arg0, String arg1) {
        throw new RuntimeException("Not implemented");
    }

    public void setWebBrowser(nsIWebBrowser arg0) {
        this.webBrowser = arg0;
    }

    public void showAsModal() {
        throw new RuntimeException("Not implemented");
    }

    public void sizeBrowserTo(int arg0, int arg1) {
        throw new RuntimeException("Not implemented");
    }

    public void onLocationChange(nsIWebProgress arg0, nsIRequest arg1, nsIURI arg2) {
    }

    public void onProgressChange(nsIWebProgress arg0, nsIRequest arg1, int arg2, int arg3, int arg4, int arg5) {
    }

    public void onSecurityChange(nsIWebProgress arg0, nsIRequest arg1, long arg2) {
    }

    public void onStateChange(nsIWebProgress aWebProgress, nsIRequest aRequest, long aStateFlags, long aStstus) {
        if ((aStateFlags & 0x80000L) != 0L && (aStateFlags & 0x10L) != 0L) {
            this.onLoadWindow();
        }
    }

    public void onStatusChange(nsIWebProgress arg0, nsIRequest arg1, long aStatus, String message) {
    }

    public void onHideTooltip() {
    }

    public void onShowTooltip(int aXCoords, int aYCoords, String aTipText) {
    }

    public Browser getBrowser() {
        return this.browser;
    }

    protected void onDispose() {
        this.webBrowser = null;
    }

    public void setText(String html) {
        this.browser.setText(html);
    }

    protected void removeProgressListener(nsIWebProgressListener progressListener) {
        block2: {
            nsIServiceManager serviceManager = mozilla.getServiceManager();
            nsIWebProgress webProgress = (nsIWebProgress)serviceManager.getServiceByContractID("@mozilla.org/docloaderservice;1", "{570f39d0-efd0-11d3-b093-00a024ffc08c}");
            try {
                webProgress.removeProgressListener(progressListener);
            }
            catch (XPCOMException xpcomException) {
                if (xpcomException.errorcode == 2147500037L) break block2;
                throw xpcomException;
            }
        }
    }
}

