/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.tiles.model.TilesConstants;
import org.jboss.tools.jst.web.tiles.model.TilesProcessImpl;
import org.jboss.tools.jst.web.tiles.model.TilesProcessItemImpl;
import org.jboss.tools.jst.web.tiles.model.TilesProcessItemOutputImpl;
import org.jboss.tools.jst.web.tiles.model.helpers.TilesDefinitionSet;

public class TilesProcessHelper
implements TilesConstants {
    private XModelObject process;
    private XModelObject config;
    private Map items = new HashMap();
    private Map targets = new HashMap();
    XModelObject[] tiles;
    Set updateLocks = new HashSet();

    public TilesProcessHelper(TilesProcessImpl process) {
        this.process = process;
    }

    public static TilesProcessHelper getHelper(XModelObject process) {
        return ((TilesProcessImpl)process).getHelper();
    }

    private synchronized void reset() {
        this.items.clear();
        this.targets.clear();
        this.config = this.process.getParent();
    }

    public void restoreRefs() {
        ((TilesProcessImpl)this.process).setReference(this.process.getParent());
    }

    public boolean isUpdateLocked() {
        return this.updateLocks.size() > 0;
    }

    public void addUpdateLock(Object lock) {
        this.updateLocks.add(lock);
    }

    public void removeUpdateLock(Object lock) {
        this.updateLocks.remove(lock);
    }

    public void updateProcess() {
        if (this.isUpdateLocked()) {
            return;
        }
        this.addUpdateLock(this);
        try {
            this.updateProcess0();
            this.updateTargets0();
        }
        finally {
            this.removeUpdateLock(this);
        }
    }

    private void updateProcess0() {
        this.reset();
        this.tiles = this.config.getChildren("TilesDefinition");
        int i = 0;
        while (i < this.tiles.length) {
            String name = this.tiles[i].getAttributeValue("name");
            XModelObject g = this.findOrCreateItem(name, name);
            this.items.put(name, g);
            String ext = this.tiles[i].getAttributeValue("extends");
            if (ext.length() > 0) {
                this.targets.put(ext, ext);
            }
            ++i;
        }
        Iterator it = this.items.keySet().iterator();
        while (it.hasNext()) {
            this.targets.remove(it.next());
        }
        this.removeObsoleteItems();
        this.createRefItems();
        this.updateItems();
    }

    public XModelObject findOrCreateItem(String path, String pp) {
        XModelObject g = this.process.getChildByPath(pp);
        if (g == null) {
            g = this.process.getModel().createModelObject("TilesProcessItem", null);
            g.setAttributeValue("name", pp);
            g.setAttributeValue("path", path);
            this.process.addChild(g);
        }
        return g;
    }

    private void removeObsoleteItems() {
        boolean q = false;
        XModelObject[] ps = this.process.getChildren("TilesProcessItem");
        int i = 0;
        while (i < ps.length) {
            String path = ps[i].getPathPart();
            if (!this.items.containsKey(path) && !this.targets.containsKey(path)) {
                if (q && "true".equals(ps[i].getAttributeValue("persistent"))) {
                    this.items.put(path, ps[i]);
                } else {
                    ps[i].removeFromParent();
                }
            }
            ++i;
        }
    }

    private void createRefItems() {
        String[] paths = this.targets.keySet().toArray(new String[0]);
        int i = 0;
        while (i < paths.length) {
            XModelObject g = this.findOrCreateItem(paths[i], paths[i]);
            this.targets.put(paths[i], g);
            ++i;
        }
    }

    private void updateItems() {
        TilesProcessItemImpl[] gs = this.items.values().toArray(new TilesProcessItemImpl[0]);
        int i = 0;
        while (i < gs.length) {
            this.setItemReference(gs[i]);
            this.updateItem(gs[i]);
            ++i;
        }
        gs = this.targets.values().toArray(new TilesProcessItemImpl[0]);
        i = 0;
        while (i < gs.length) {
            gs[i].setReference(null);
            this.updateItem(gs[i]);
            ++i;
        }
    }

    private void setItemReference(TilesProcessItemImpl item) {
        String path = item.getPathPart();
        XModelObject r = this.config.getChildByPath(path);
        item.setReference(r);
    }

    private void updateItem(TilesProcessItemImpl item) {
        if (!item.isUpToDate()) {
            item.notifyUpdate();
            XModelObject r = item.getReference();
            if (r != null) {
                item.setAttributeValue("path", r.getAttributeValue("name"));
            }
        }
        this.updateOutputs(item);
    }

    private void updateOutputs(TilesProcessItemImpl item) {
        XModelObject r = item.getReference();
        String ext = r == null ? "" : r.getAttributeValue("extends");
        this.updateOutputs(item, ext, item.getChildren());
    }

    private void updateOutputs(TilesProcessItemImpl item, String ext, XModelObject[] outputs) {
        XModelObject output = null;
        if (ext.length() == 0) {
            int i = 0;
            while (i < outputs.length) {
                outputs[i].removeFromParent();
                ++i;
            }
            return;
        }
        output = outputs.length == 0 ? this.createOutput((XModelObject)item, (XModelObject)item) : outputs[0];
        TilesProcessItemOutputImpl r = (TilesProcessItemOutputImpl)output;
        r.setReference(item.getReference());
        this.updateOutput(r);
    }

    private XModelObject createOutput(XModelObject item, XModelObject r) {
        XModelObject output = item.getModel().createModelObject("TilesProcessItemOutput", null);
        output.setAttributeValue("path", r.getAttributeValue("extends"));
        String name = XModelObjectUtil.createNewChildName((String)"output", (XModelObject)item);
        output.setAttributeValue("name", name);
        item.addChild(output);
        return output;
    }

    private void updateOutput(TilesProcessItemOutputImpl output) {
        output.notifyUpdate();
        XModelObject r = output.getReference();
        String path = r.getAttributeValue("extends");
        output.setAttributeValue("path", path);
        String title = path;
        output.setAttributeValue("title", title);
        XModelObject g = this.findItem(path);
        String target = g == null ? "" : g.getPathPart();
        output.setAttributeValue("target", target);
    }

    public XModelObject findItem(String path) {
        XModelObject g = (XModelObject)this.items.get(path);
        if (g == null) {
            g = (XModelObject)this.targets.get(path);
        }
        return g;
    }

    public void updateTargets() {
        if (this.isUpdateLocked()) {
            return;
        }
        this.addUpdateLock(this);
        try {
            this.updateTargets0();
        }
        finally {
            this.removeUpdateLock(this);
        }
    }

    private void updateTargets0() {
        Map<String, XModelObject> ds = TilesDefinitionSet.getInstance(this.process.getModel()).getDefinitions();
        XModelObject[] ts = this.targets.values().toArray(new XModelObject[0]);
        int i = 0;
        while (i < ts.length) {
            boolean b = ds.containsKey(ts[i].getAttributeValue("name"));
            ts[i].setAttributeValue("confirmed", b ? "true" : "false");
            ++i;
        }
    }

    public boolean isDisposed() {
        return this.process == null || !this.process.isActive();
    }
}

