/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.jst.web.tiles.model.helpers.ITilesDefinitionSetContributor;
import org.jboss.tools.jst.web.tiles.model.helpers.ITilesDefinitionSetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesDefinitionSet
implements XModelTreeListener {
    static String[] CONTRIBUTORS = new String[]{"org.jboss.tools.struts.model.helpers.TilesContributor"};
    static ITilesDefinitionSetContributor[] contributors;
    XModel model;
    Set<XModelObject> tiles = new HashSet<XModelObject>();
    Map<String, XModelObject> definitions = new HashMap<String, XModelObject>();
    Set<ITilesDefinitionSetListener> listeners = new HashSet<ITilesDefinitionSetListener>();

    static {
        TilesDefinitionSet.loadContributors();
    }

    static void loadContributors() {
        ArrayList<ITilesDefinitionSetContributor> list = new ArrayList<ITilesDefinitionSetContributor>();
        int i = 0;
        while (i < CONTRIBUTORS.length) {
            Object watcher = ModelFeatureFactory.getInstance().createFeatureInstance(CONTRIBUTORS[i]);
            if (watcher instanceof ITilesDefinitionSetContributor) {
                list.add((ITilesDefinitionSetContributor)watcher);
            } else if (ModelPlugin.isDebugEnabled()) {
                ModelPlugin.getPluginLog().logInfo("Class is not implemented IWatcherContributor interface!");
            }
            ++i;
        }
        contributors = list.toArray(new ITilesDefinitionSetContributor[0]);
    }

    public static synchronized TilesDefinitionSet getInstance(XModel model) {
        TilesDefinitionSet instance = (TilesDefinitionSet)model.getManager("TilesDefinitionSet");
        if (instance == null) {
            instance = new TilesDefinitionSet();
            instance.setModel(model);
            model.addManager("TilesDefinitionSet", (Object)instance);
            model.addModelTreeListener((XModelTreeListener)instance);
        }
        return instance;
    }

    void setModel(XModel model) {
        this.model = model;
        this.update();
    }

    public Map<String, XModelObject> getDefinitions() {
        return this.definitions;
    }

    public void addTilesDefinitionSetListener(ITilesDefinitionSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeTilesDefinitionSetListener(ITilesDefinitionSetListener listener) {
        this.listeners.remove(listener);
    }

    public void nodeChanged(XModelTreeEvent event) {
        this.processEvent(event);
    }

    public void structureChanged(XModelTreeEvent event) {
        this.processEvent(event);
    }

    private void processEvent(XModelTreeEvent event) {
        boolean b = false;
        int i = 0;
        while (!b && i < contributors.length) {
            if (contributors[i].isRelevant(event)) {
                b = true;
            }
            ++i;
        }
        if (b) {
            this.update();
        }
    }

    public void update() {
        HashSet<XModelObject> s = new HashSet<XModelObject>();
        int i = 0;
        while (i < contributors.length) {
            s.addAll(contributors[i].getTileFiles(this.model));
            ++i;
        }
        this.tiles = s;
        this.updateDefinitions();
    }

    void updateDefinitions() {
        HashMap<String, XModelObject> d = new HashMap<String, XModelObject>();
        Iterator<XModelObject> it = this.tiles.iterator();
        while (it.hasNext()) {
            XModelObject o = it.next();
            XModelObject[] cs = o.getChildren("TilesDefinition");
            int i = 0;
            while (i < cs.length) {
                d.put(cs[i].getAttributeValue("name"), cs[i]);
                ++i;
            }
        }
        Map<String, XModelObject> old = this.definitions;
        this.definitions = d;
        HashSet<XModelObject> removed = new HashSet<XModelObject>();
        HashSet<XModelObject> added = new HashSet<XModelObject>();
        Iterator<String> it2 = old.keySet().iterator();
        while (it.hasNext()) {
            String key = it2.next();
            if (d.containsKey(key)) continue;
            removed.add(old.get(key));
        }
        for (String key : d.keySet()) {
            if (old.containsKey(key)) continue;
            added.add((XModelObject)d.get(key));
        }
        if (!removed.isEmpty() || !added.isEmpty()) {
            ITilesDefinitionSetListener[] ls = this.listeners.toArray(new ITilesDefinitionSetListener[0]);
            int i = 0;
            while (i < ls.length) {
                ls[i].definitionsChanged(removed, added);
                ++i;
            }
        }
    }
}

