/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class TilesDefinitionAdopt
implements XAdoptManager {
    public boolean isAdoptable(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        return target != null && target.isObjectEditable() && (entity.startsWith("StrutsAction") || entity.equals("FileJSP") || entity.startsWith("FileHTML"));
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        String entity = object.getModelEntity().getName();
        if (entity.startsWith("StrutsAction")) {
            this.adoptAction(target, object);
        }
        if (entity.equals("FileJSP") || entity.startsWith("FileHTML")) {
            this.adoptPage(target, object);
        }
    }

    private void adoptAction(XModelObject target, XModelObject object) throws XModelException {
        String path = object.getAttributeValue("path");
        XModelObject cg = object;
        while (cg != null && !cg.getModelEntity().getName().startsWith("StrutsConfig")) {
            cg = cg.getParent();
        }
        path = String.valueOf(this.getModuleForConfig(cg)) + path;
        target.getModel().changeObjectAttribute(target, "controllerUrl", path);
    }

    private void adoptPage(XModelObject target, XModelObject object) throws XModelException {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        if (path == null) {
            return;
        }
        XModelObject fs = object;
        while (fs != null && fs.getFileType() != 3) {
            fs = fs.getParent();
        }
        path = String.valueOf(this.getModuleForFileSystem(fs)) + path;
        target.getModel().changeObjectAttribute(target, "path", path);
    }

    private String getModuleForConfig(XModelObject cg) {
        if (cg == null) {
            return "";
        }
        String mp = XModelObjectLoaderUtil.getResourcePath((XModelObject)cg);
        XModelObject[] ms = cg.getModel().getByPath("Web").getChildren();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getAttributeValue("model path").equals(mp)) {
                return ms[i].getAttributeValue("name");
            }
            ++i;
        }
        return "";
    }

    private String getModuleForFileSystem(XModelObject fs) {
        if (fs == null) {
            return "";
        }
        XModelObject web = fs.getModel().getByPath("Web");
        XModelObject[] ms = web.getChildren("JstWebModule");
        String n = fs.getAttributeValue("name");
        int i = 0;
        while (i < ms.length) {
            if (n.equals(ms[i].getAttributeValue("root file system"))) {
                return ms[i].getAttributeValue("name");
            }
            ++i;
        }
        return "";
    }
}

