/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.CreateFileSupport;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.jst.web.tiles.Messages;
import org.jboss.tools.jst.web.tiles.model.TilesProcessImpl;
import org.jboss.tools.jst.web.tiles.model.helpers.TilesRegistrationHelper;

public class CreateTilesSupport
extends CreateFileSupport {
    static String REGISTER = "register";

    public void reset() {
        super.reset();
        this.setAttributeValue(0, "register", this.canRegisterInternal() ? "yes" : "no");
    }

    protected void execute() throws XModelException {
        Properties p0 = this.extractStepData(0);
        XUndoManager undo = this.getTarget().getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(MessageFormat.format(Messages.CreateTilesSupport_CreateTiles, this.getTarget().getAttributeValue("element type"), this.getTarget().getPresentationString()), 1);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.doExecute(p0);
            }
            catch (RuntimeException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    private void doExecute(Properties p0) throws XModelException {
        Properties p = this.extractStepData(0);
        String path = p.getProperty("name");
        XModelObject file = this.createFile(path = this.revalidatePath(path));
        if (file == null) {
            return;
        }
        if (this.canRegisterInternal() && "yes".equals(this.getAttributeValue(0, REGISTER))) {
            this.registerInternal(file);
        }
        TilesProcessImpl process = (TilesProcessImpl)file.getChildByPath("process");
        process.firePrepared();
        this.open(file);
    }

    protected XModelObject modifyCreatedObject(XModelObject o) {
        XModelObject d = o.getModel().createModelObject("TilesDefinition", null);
        d.setAttributeValue("name", o.getAttributeValue("name"));
        o.addChild(d);
        return o;
    }

    private boolean canRegisterInternal() {
        return TilesRegistrationHelper.isEnabled(this.getTarget().getModel());
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        if (REGISTER.equals(name)) {
            return this.canRegisterInternal();
        }
        return true;
    }

    void registerInternal(XModelObject file) {
        TilesRegistrationHelper.register(this.getTarget().getModel(), file);
    }
}

