/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.verification.vrules;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.verification.vrules.WebDefaultCheck;

public class CheckRoleReferenceName
extends WebDefaultCheck {
    static String ATTR = "role-name";

    public VResult[] check(VObject object) {
        String roleName;
        XModelObject o = ((VObjectImpl)object).getModelObject();
        String attr = this.rule.getProperty("attribute");
        if (attr == null || attr.length() == 0) {
            attr = ATTR;
        }
        if ((roleName = o.getAttributeValue(attr)) == null) {
            return null;
        }
        if (roleName.length() == 0) {
            return this.fire(object, "role.empty", attr, null);
        }
        if (!this.isRoleNameOk(o, roleName)) {
            return this.fire(object, "role", attr, roleName);
        }
        return null;
    }

    boolean isRoleNameOk(XModelObject mapping, String roleName) {
        if (roleName.equalsIgnoreCase("NONE")) {
            return true;
        }
        if ("*".equals(roleName)) {
            return true;
        }
        return this.findRole(mapping, roleName) != null;
    }

    XModelObject findRole(XModelObject mapping, String name) {
        XModelObject webxml = WebAppHelper.getParentFile((XModelObject)mapping);
        if (webxml == null) {
            return null;
        }
        XModelObject[] cs = WebAppHelper.getRoles((XModelObject)webxml);
        int i = 0;
        while (i < cs.length) {
            if (name.equals(cs[i].getAttributeValue(ATTR))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }
}

