/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.message.Message;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTimestamp
extends Value {
    public static final int PRECISION = 23;
    static final int DISPLAY_SIZE = 23;
    static final int DEFAULT_SCALE = 10;
    static final long YEAR_ONE = Date.valueOf("0001-01-02").getTime();
    private final Timestamp value;

    private ValueTimestamp(Timestamp timestamp) {
        this.value = timestamp;
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.value.clone();
    }

    public Timestamp getTimestampNoCopy() {
        return this.value;
    }

    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    public static Timestamp parseTimestamp(String string) throws SQLException {
        return (Timestamp)DateTimeUtils.parseDateTime(string, 11, 90011);
    }

    public int getType() {
        return 11;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value;
        return Integer.signum(this.value.compareTo(valueTimestamp.value));
    }

    public String getString() {
        int n;
        String string = this.value.toString();
        long l = this.value.getTime();
        if (l < YEAR_ONE && (n = DateTimeUtils.getDatePart(this.value, 1)) < 1) {
            string = n + string.substring(string.indexOf(45));
        }
        return string;
    }

    public long getPrecision() {
        return 23L;
    }

    public int getScale() {
        return 10;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.getTimestamp();
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTimestamp(n, this.value);
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        timestamp = (Timestamp)timestamp.clone();
        return ValueTimestamp.getNoCopy(timestamp);
    }

    public static ValueTimestamp getNoCopy(Timestamp timestamp) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(timestamp));
    }

    public Value convertScale(boolean bl, int n) throws SQLException {
        if (n < 0 || n > 10) {
            throw Message.getInvalidValueException("" + n, "scale");
        }
        int n2 = this.value.getNanos();
        BigDecimal bigDecimal = new BigDecimal("" + n2);
        bigDecimal = bigDecimal.movePointLeft(9);
        bigDecimal = MathUtils.setScale(bigDecimal, n);
        int n3 = (bigDecimal = bigDecimal.movePointRight(9)).intValue();
        if (n3 == n2) {
            return this;
        }
        long l = this.value.getTime();
        while (n3 >= 1000000000) {
            l += 1000L;
            n3 -= 1000000000;
        }
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n3);
        return ValueTimestamp.getNoCopy(timestamp);
    }

    public int getDisplaySize() {
        return 23;
    }

    public boolean equals(Object object) {
        return object instanceof ValueTimestamp && this.value.equals(((ValueTimestamp)object).value);
    }
}

