/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import org.h2.api.CloseListener;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;
import org.h2.util.ClassUtils;
import org.h2.value.DataType;
import org.h2.value.Value;

public class TriggerObject
extends SchemaObjectBase {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private boolean before;
    private int typeMask;
    private boolean rowBased;
    private int queueSize = 1024;
    private boolean noWait;
    private Table table;
    private String triggerClassName;
    private Trigger triggerCallback;

    public TriggerObject(Schema schema, int n, String string, Table table) {
        this.initSchemaObjectBase(schema, n, string, "trigger");
        this.table = table;
        this.setTemporary(table.isTemporary());
    }

    public void setBefore(boolean bl) {
        this.before = bl;
    }

    private synchronized void load(Session session) throws SQLException {
        if (this.triggerCallback != null) {
            return;
        }
        try {
            JdbcConnection jdbcConnection = session.createConnection(false);
            Object obj = ClassUtils.loadUserClass(this.triggerClassName).newInstance();
            this.triggerCallback = (Trigger)obj;
            this.triggerCallback.init(jdbcConnection, this.getSchema().getName(), this.getName(), this.table.getName(), this.before, this.typeMask);
        }
        catch (Throwable throwable) {
            this.triggerCallback = null;
            throw Message.getSQLException(90043, throwable, this.getName(), this.triggerClassName, throwable.toString());
        }
    }

    public void setTriggerClassName(Session session, String string, boolean bl) throws SQLException {
        block2: {
            this.triggerClassName = string;
            try {
                this.load(session);
            }
            catch (SQLException sQLException) {
                if (bl) break block2;
                throw sQLException;
            }
        }
    }

    public void fire(Session session, boolean bl) throws SQLException {
        if (this.rowBased || this.before != bl) {
            return;
        }
        this.load(session);
        JdbcConnection jdbcConnection = session.createConnection(false);
        boolean bl2 = session.setCommitOrRollbackDisabled(true);
        Value value = session.getScopeIdentity();
        try {
            this.triggerCallback.fire(jdbcConnection, null, null);
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90044, throwable, this.getName(), this.triggerClassName, throwable.toString());
        }
        finally {
            session.setScopeIdentity(value);
            session.setCommitOrRollbackDisabled(bl2);
        }
    }

    private Object[] convertToObjectList(Row row) {
        if (row == null) {
            return null;
        }
        int n = row.getColumnCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = row.getValue(i).getObject();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRow(Session session, Row row, Row row2, boolean bl) throws SQLException {
        Object[] objectArray;
        if (!this.rowBased || this.before != bl) {
            return;
        }
        this.load(session);
        boolean bl2 = false;
        if ((this.typeMask & 1) != 0 && row == null && row2 != null) {
            bl2 = true;
        }
        if ((this.typeMask & 2) != 0 && row != null && row2 != null) {
            bl2 = true;
        }
        if ((this.typeMask & 4) != 0 && row != null && row2 == null) {
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        Object[] objectArray2 = this.convertToObjectList(row);
        Object[] objectArray3 = this.convertToObjectList(row2);
        if (this.before && objectArray3 != null) {
            objectArray = new Object[objectArray3.length];
            for (int i = 0; i < objectArray3.length; ++i) {
                objectArray[i] = objectArray3[i];
            }
        } else {
            objectArray = null;
        }
        JdbcConnection jdbcConnection = session.createConnection(false);
        boolean bl3 = session.getAutoCommit();
        boolean bl4 = session.setCommitOrRollbackDisabled(true);
        Value value = session.getScopeIdentity();
        try {
            session.setAutoCommit(false);
            this.triggerCallback.fire(jdbcConnection, objectArray2, objectArray3);
            if (objectArray != null) {
                for (int i = 0; i < objectArray3.length; ++i) {
                    Object object = objectArray3[i];
                    if (object == objectArray[i]) continue;
                    Value value2 = DataType.convertToValue(session, object, -1);
                    row2.setValue(i, value2);
                }
            }
        }
        finally {
            session.setScopeIdentity(value);
            session.setCommitOrRollbackDisabled(bl4);
            session.setAutoCommit(bl3);
        }
    }

    public void setTypeMask(int n) {
        this.typeMask = n;
    }

    public void setRowBased(boolean bl) {
        this.rowBased = bl;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE TRIGGER ");
        stringBuilder.append(string);
        if (this.before) {
            stringBuilder.append(" BEFORE ");
        } else {
            stringBuilder.append(" AFTER ");
        }
        stringBuilder.append(this.getTypeNameList()).append(" ON ").append(table.getSQL());
        if (this.rowBased) {
            stringBuilder.append(" FOR EACH ROW");
        }
        if (this.noWait) {
            stringBuilder.append(" NOWAIT");
        } else {
            stringBuilder.append(" QUEUE ").append(this.queueSize);
        }
        stringBuilder.append(" CALL ").append(Parser.quoteIdentifier(this.triggerClassName));
        return stringBuilder.toString();
    }

    public String getTypeNameList() {
        StringBuilder stringBuilder = new StringBuilder();
        if ((this.typeMask & 1) != 0) {
            stringBuilder.append("INSERT");
        }
        if ((this.typeMask & 2) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("UPDATE");
        }
        if ((this.typeMask & 4) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("DELETE");
        }
        return stringBuilder.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public int getType() {
        return 4;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeTrigger(this);
        this.database.removeMeta(session, this.getId());
        if (this.triggerCallback != null && this.triggerCallback instanceof CloseListener) {
            ((CloseListener)((Object)this.triggerCallback)).remove();
        }
        this.table = null;
        this.triggerClassName = null;
        this.triggerCallback = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String getTriggerClassName() {
        return this.triggerClassName;
    }

    public void close() throws SQLException {
        if (this.triggerCallback != null && this.triggerCallback instanceof CloseListener) {
            ((CloseListener)((Object)this.triggerCallback)).close();
        }
    }
}

