/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import winstone.AuthenticationHandler;
import winstone.FilterConfiguration;
import winstone.Launcher;
import winstone.Logger;
import winstone.Mapping;
import winstone.ServletConfiguration;
import winstone.WebAppConfiguration;
import winstone.WinstoneRequest;
import winstone.WinstoneResponse;

public class RequestDispatcher
implements javax.servlet.RequestDispatcher,
FilterChain {
    static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    static final String ERROR_MESSAGE = "javax.servlet.error.message";
    static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    private WebAppConfiguration webAppConfig;
    private ServletConfiguration servletConfig;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String requestURI;
    private Integer errorStatusCode;
    private Throwable errorException;
    private String errorSummaryMessage;
    private AuthenticationHandler authHandler;
    private Mapping[] forwardFilterPatterns;
    private Mapping[] includeFilterPatterns;
    private FilterConfiguration[] matchingFilters;
    private int matchingFiltersEvaluated;
    private Boolean doInclude;
    private boolean isErrorDispatch;
    private boolean useRequestAttributes;
    private WebAppConfiguration includedWebAppConfig;
    private ServletConfiguration includedServletConfig;

    public RequestDispatcher(WebAppConfiguration webAppConfig, ServletConfiguration servletConfig) {
        this.servletConfig = servletConfig;
        this.webAppConfig = webAppConfig;
        this.matchingFiltersEvaluated = 0;
    }

    public void setForNamedDispatcher(Mapping[] forwardFilterPatterns, Mapping[] includeFilterPatterns) {
        this.forwardFilterPatterns = forwardFilterPatterns;
        this.includeFilterPatterns = includeFilterPatterns;
        this.matchingFilters = null;
        this.useRequestAttributes = false;
        this.isErrorDispatch = false;
    }

    public void setForURLDispatcher(String servletPath, String pathInfo, String queryString, String requestURIInsideWebapp, Mapping[] forwardFilterPatterns, Mapping[] includeFilterPatterns) {
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.requestURI = requestURIInsideWebapp;
        this.forwardFilterPatterns = forwardFilterPatterns;
        this.includeFilterPatterns = includeFilterPatterns;
        this.matchingFilters = null;
        this.useRequestAttributes = true;
        this.isErrorDispatch = false;
    }

    public void setForErrorDispatcher(String servletPath, String pathInfo, String queryString, int statusCode, String summaryMessage, Throwable exception, String errorHandlerURI, Mapping[] errorFilterPatterns) {
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.requestURI = errorHandlerURI;
        this.errorStatusCode = new Integer(statusCode);
        this.errorException = exception;
        this.errorSummaryMessage = summaryMessage;
        this.matchingFilters = RequestDispatcher.getMatchingFilters(errorFilterPatterns, this.webAppConfig, servletPath + (pathInfo == null ? "" : pathInfo), this.getName(), "ERROR", servletPath != null);
        this.useRequestAttributes = true;
        this.isErrorDispatch = true;
    }

    public void setForInitialDispatcher(String servletPath, String pathInfo, String queryString, String requestURIInsideWebapp, Mapping[] requestFilterPatterns, AuthenticationHandler authHandler) {
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.requestURI = requestURIInsideWebapp;
        this.authHandler = authHandler;
        this.matchingFilters = RequestDispatcher.getMatchingFilters(requestFilterPatterns, this.webAppConfig, servletPath + (pathInfo == null ? "" : pathInfo), this.getName(), "REQUEST", servletPath != null);
        this.useRequestAttributes = false;
        this.isErrorDispatch = false;
    }

    public String getName() {
        return this.servletConfig.getServletName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.doInclude == null) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "RequestDispatcher.IncludeMessage", new String[]{this.getName(), this.requestURI});
            WinstoneRequest wr = this.getUnwrappedRequest(request);
            wr.addIncludeQueryParameters(this.queryString);
            if (this.useRequestAttributes) {
                wr.addIncludeAttributes(this.webAppConfig.getContextPath() + this.requestURI, this.webAppConfig.getContextPath(), this.servletPath, this.pathInfo, this.queryString);
            }
            WinstoneResponse wresp = this.getUnwrappedResponse(response);
            wresp.startIncludeBuffer();
            this.includedServletConfig = wr.getServletConfig();
            this.includedWebAppConfig = wr.getWebAppConfig();
            wr.setServletConfig(this.servletConfig);
            wr.setWebAppConfig(this.webAppConfig);
            wresp.setWebAppConfig(this.webAppConfig);
            this.doInclude = Boolean.TRUE;
        }
        if (this.matchingFilters == null) {
            this.matchingFilters = RequestDispatcher.getMatchingFilters(this.includeFilterPatterns, this.webAppConfig, this.servletPath + (this.pathInfo == null ? "" : this.pathInfo), this.getName(), "INCLUDE", this.servletPath != null);
        }
        try {
            if (this.matchingFiltersEvaluated < this.matchingFilters.length) {
                this.doFilter(request, response);
                this.finishInclude(request, response);
                return;
            }
            try {
                this.servletConfig.execute(request, response, this.webAppConfig.getContextPath() + this.requestURI);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.matchingFilters.length != 0) throw throwable;
                this.finishInclude(request, response);
                throw throwable;
            }
            if (this.matchingFilters.length != 0) return;
            this.finishInclude(request, response);
            return;
        }
        catch (Throwable err) {
            this.finishInclude(request, response);
            if (err instanceof ServletException) {
                throw (ServletException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            if (!(err instanceof Error)) throw (RuntimeException)err;
            throw (Error)err;
        }
    }

    private void finishInclude(ServletRequest request, ServletResponse response) throws IOException {
        WinstoneRequest wr = this.getUnwrappedRequest(request);
        wr.removeIncludeQueryString();
        if (this.useRequestAttributes) {
            wr.removeIncludeAttributes();
        }
        WinstoneResponse wresp = this.getUnwrappedResponse(response);
        wresp.finishIncludeBuffer();
        if (this.includedServletConfig != null) {
            wr.setServletConfig(this.includedServletConfig);
            this.includedServletConfig = null;
        }
        if (this.includedWebAppConfig != null) {
            wr.setWebAppConfig(this.includedWebAppConfig);
            wresp.setWebAppConfig(this.includedWebAppConfig);
            this.includedWebAppConfig = null;
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean outsideFilter;
        WinstoneResponse rsp;
        if (this.doInclude == null) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "RequestDispatcher.ForwardMessage", new String[]{this.getName(), this.requestURI});
            if (response.isCommitted()) {
                throw new IllegalStateException(Launcher.RESOURCES.getString("RequestDispatcher.ForwardCommitted"));
            }
            WinstoneRequest req = this.getUnwrappedRequest(request);
            rsp = this.getUnwrappedResponse(response);
            rsp.resetBuffer();
            req.clearIncludeStackForForward();
            rsp.clearIncludeStackForForward();
            if (this.useRequestAttributes) {
                req.setAttribute(FORWARD_REQUEST_URI, req.getRequestURI());
                req.setAttribute(FORWARD_CONTEXT_PATH, req.getContextPath());
                req.setAttribute(FORWARD_SERVLET_PATH, req.getServletPath());
                req.setAttribute(FORWARD_PATH_INFO, req.getPathInfo());
                req.setAttribute(FORWARD_QUERY_STRING, req.getQueryString());
                if (this.isErrorDispatch) {
                    req.setAttribute(ERROR_REQUEST_URI, req.getRequestURI());
                    req.setAttribute(ERROR_STATUS_CODE, this.errorStatusCode);
                    req.setAttribute(ERROR_MESSAGE, this.errorSummaryMessage != null ? this.errorSummaryMessage : "");
                    if (req.getServletConfig() != null) {
                        req.setAttribute(ERROR_SERVLET_NAME, req.getServletConfig().getServletName());
                    }
                    if (this.errorException != null) {
                        req.setAttribute(ERROR_EXCEPTION_TYPE, this.errorException.getClass());
                        req.setAttribute(ERROR_EXCEPTION, this.errorException);
                    }
                    rsp.setErrorStatusCode(this.errorStatusCode);
                    request = req;
                    response = rsp;
                }
            }
            req.setServletPath(this.servletPath);
            req.setPathInfo(this.pathInfo);
            req.setRequestURI(this.webAppConfig.getContextPath() + this.requestURI);
            req.setForwardQueryString(this.queryString);
            req.setWebAppConfig(this.webAppConfig);
            req.setServletConfig(this.servletConfig);
            req.setRequestAttributeListeners(this.webAppConfig.getRequestAttributeListeners());
            rsp.setWebAppConfig(this.webAppConfig);
            if (this.matchingFilters == null) {
                this.matchingFilters = RequestDispatcher.getMatchingFilters(this.forwardFilterPatterns, this.webAppConfig, this.servletPath + (this.pathInfo == null ? "" : this.pathInfo), this.getName(), "FORWARD", this.servletPath != null);
            } else if (!this.isErrorDispatch && !this.continueAfterSecurityCheck(request, response)) {
                return;
            }
            this.doInclude = Boolean.FALSE;
        }
        boolean bl = outsideFilter = this.matchingFiltersEvaluated == 0;
        if (this.matchingFiltersEvaluated < this.matchingFilters.length) {
            this.doFilter(request, response);
        } else {
            this.servletConfig.execute(request, response, this.webAppConfig.getContextPath() + this.requestURI);
        }
        if (outsideFilter) {
            rsp = this.getUnwrappedResponse(response);
            rsp.flushBuffer();
            rsp.getWinstoneOutputStream().setClosed(true);
        }
    }

    private boolean continueAfterSecurityCheck(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.authHandler != null) {
            return this.authHandler.processAuthentication(request, response, this.servletPath + (this.pathInfo == null ? "" : this.pathInfo));
        }
        return true;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.matchingFiltersEvaluated < this.matchingFilters.length) {
            FilterConfiguration filter = this.matchingFilters[this.matchingFiltersEvaluated++];
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "RequestDispatcher.ExecutingFilter", filter.getFilterName());
            filter.execute(request, response, this);
            return;
        }
        if (this.doInclude == null) {
            return;
        }
        if (this.doInclude.booleanValue()) {
            this.include(request, response);
        } else {
            this.forward(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FilterConfiguration[] getMatchingFilters(Mapping[] filterPatterns, WebAppConfiguration webAppConfig, String fullPath, String servletName, String filterChainType, boolean isURLBasedMatch) {
        Map cache;
        String cacheKey = null;
        cacheKey = isURLBasedMatch ? filterChainType + ":URI:" + fullPath : filterChainType + ":Servlet:" + servletName;
        FilterConfiguration[] matchingFilters = null;
        Map map = cache = webAppConfig.getFilterMatchCache();
        synchronized (map) {
            matchingFilters = (FilterConfiguration[])cache.get(cacheKey);
            if (matchingFilters == null) {
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestDispatcher.CalcFilterChain", cacheKey);
                ArrayList outFilters = new ArrayList();
                for (int n = 0; n < filterPatterns.length; ++n) {
                    Mapping filterPattern = filterPatterns[n];
                    if (filterPattern.getLinkName() != null && (filterPattern.getLinkName().equals(servletName) || filterPattern.getLinkName().equals("*"))) {
                        outFilters.add(webAppConfig.getFilters().get(filterPattern.getMappedTo()));
                        continue;
                    }
                    if (filterPattern.getLinkName() != null || !isURLBasedMatch || !filterPattern.match(fullPath, null, null)) continue;
                    outFilters.add(webAppConfig.getFilters().get(filterPattern.getMappedTo()));
                }
                matchingFilters = outFilters.toArray(new FilterConfiguration[0]);
                cache.put(cacheKey, matchingFilters);
            } else {
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestDispatcher.UseCachedFilterChain", cacheKey);
            }
        }
        return matchingFilters;
    }

    protected WinstoneRequest getUnwrappedRequest(ServletRequest request) {
        ServletRequest workingRequest = request;
        while (workingRequest instanceof ServletRequestWrapper) {
            workingRequest = ((ServletRequestWrapper)workingRequest).getRequest();
        }
        return (WinstoneRequest)workingRequest;
    }

    protected WinstoneResponse getUnwrappedResponse(ServletResponse response) {
        ServletResponse workingResponse = response;
        while (workingResponse instanceof ServletResponseWrapper) {
            workingResponse = ((ServletResponseWrapper)workingResponse).getResponse();
        }
        return (WinstoneResponse)workingResponse;
    }
}

